/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsEndpoint;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsEndpointFactory;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsHttpMethod;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregator;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregatorElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregatorField;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregatorProperty;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResource;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceProperty;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.search.JavaElementsSearcher;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementCategory;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IAnnotatedSourceType;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsApplication;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public class JaxrsElementChangedProcessorDelegate {
    public static void processEvent(JaxrsElementDelta event) throws CoreException {
        IJaxrsElement element = event.getElement();
        EnumElementCategory elementKind = element.getElementKind().getCategory();
        Flags flags = event.getFlags();
        block0 : switch (event.getDeltaKind()) {
            case 1: {
                switch (elementKind) {
                    case APPLICATION: {
                        JaxrsElementChangedProcessorDelegate.processAddition((IJaxrsApplication)element);
                        break block0;
                    }
                    case HTTP_METHOD: {
                        JaxrsElementChangedProcessorDelegate.processAddition((JaxrsHttpMethod)element);
                        break block0;
                    }
                    case RESOURCE_METHOD: {
                        JaxrsElementChangedProcessorDelegate.processAddition((JaxrsResourceMethod)element);
                        break block0;
                    }
                    case RESOURCE_FIELD: {
                        JaxrsElementChangedProcessorDelegate.processAddition((JaxrsResourceElement)element);
                        break block0;
                    }
                    case RESOURCE_PROPERTY: {
                        JaxrsElementChangedProcessorDelegate.processAddition((JaxrsResourceProperty)element);
                        break block0;
                    }
                    case PARAMETER_AGGREGATOR_FIELD: {
                        JaxrsElementChangedProcessorDelegate.processAddition((JaxrsParameterAggregatorField)element, flags);
                        break block0;
                    }
                    case PARAMETER_AGGREGATOR_PROPERTY: {
                        JaxrsElementChangedProcessorDelegate.processAddition((JaxrsParameterAggregatorProperty)element, flags);
                        break block0;
                    }
                }
                Logger.trace("No direct impact on JAX-RS Endpoints after change on element:" + (Object)((Object)elementKind), new Object[0]);
                break;
            }
            case 4: {
                switch (elementKind) {
                    case APPLICATION: {
                        JaxrsElementChangedProcessorDelegate.processChange((IJaxrsApplication)element, flags);
                        break block0;
                    }
                    case HTTP_METHOD: {
                        JaxrsElementChangedProcessorDelegate.processChange((JaxrsHttpMethod)element, flags);
                        break block0;
                    }
                    case RESOURCE: {
                        JaxrsElementChangedProcessorDelegate.processChange((JaxrsResource)element, flags);
                        break block0;
                    }
                    case RESOURCE_METHOD: {
                        JaxrsElementChangedProcessorDelegate.processChange((JaxrsResourceMethod)element, flags);
                        break block0;
                    }
                    case RESOURCE_FIELD: {
                        JaxrsElementChangedProcessorDelegate.processChange((JaxrsResourceElement)element, flags);
                        break block0;
                    }
                    case RESOURCE_PROPERTY: {
                        JaxrsElementChangedProcessorDelegate.processChange((JaxrsResourceProperty)element, flags);
                        break block0;
                    }
                    case PARAMETER_AGGREGATOR_FIELD: {
                        JaxrsElementChangedProcessorDelegate.processChange((JaxrsParameterAggregatorField)element, flags);
                        break block0;
                    }
                    case PARAMETER_AGGREGATOR_PROPERTY: {
                        JaxrsElementChangedProcessorDelegate.processChange((JaxrsParameterAggregatorProperty)element, flags);
                        break block0;
                    }
                }
                Logger.trace("No direct impact on JAX-RS Endpoints after change on element:" + (Object)((Object)elementKind), new Object[0]);
                break;
            }
            case 2: {
                switch (elementKind) {
                    case APPLICATION: {
                        JaxrsElementChangedProcessorDelegate.processRemoval((IJaxrsApplication)element);
                        break block0;
                    }
                    case HTTP_METHOD: {
                        JaxrsElementChangedProcessorDelegate.processRemoval((JaxrsHttpMethod)element);
                        break block0;
                    }
                    case RESOURCE_METHOD: {
                        JaxrsElementChangedProcessorDelegate.processRemoval((JaxrsResourceMethod)element);
                        break block0;
                    }
                    case RESOURCE_FIELD: {
                        JaxrsElementChangedProcessorDelegate.processRemoval((JaxrsResourceElement)element, flags);
                        break block0;
                    }
                    case RESOURCE_PROPERTY: {
                        JaxrsElementChangedProcessorDelegate.processRemoval((JaxrsResourceProperty)element, flags);
                        break block0;
                    }
                    case PARAMETER_AGGREGATOR_FIELD: {
                        JaxrsElementChangedProcessorDelegate.processRemoval((JaxrsParameterAggregatorField)element, flags);
                        break block0;
                    }
                    case PARAMETER_AGGREGATOR_PROPERTY: {
                        JaxrsElementChangedProcessorDelegate.processRemoval((JaxrsParameterAggregatorProperty)element, flags);
                        break block0;
                    }
                }
                Logger.trace("No direct impact on JAX-RS Endpoints after change on element:" + (Object)((Object)elementKind), new Object[0]);
            }
        }
    }

    private static void processAddition(IJaxrsApplication application) {
        JaxrsMetamodel metamodel = (JaxrsMetamodel)application.getMetamodel();
        if (application.equals(metamodel.findApplication())) {
            for (JaxrsEndpoint endpoint : metamodel.getAllEndpoints()) {
                endpoint.update(application);
            }
        }
    }

    private static void processAddition(JaxrsHttpMethod httpMethod) {
    }

    private static void processAddition(JaxrsResourceMethod resourceMethod) throws CoreException {
        JaxrsMetamodel metamodel = resourceMethod.getMetamodel();
        JaxrsResource resource = resourceMethod.getParentResource();
        if (resource == null) {
            Logger.warn("Found an orphan resource method: " + resourceMethod);
        } else {
            switch (resourceMethod.getElementKind()) {
                case RESOURCE_METHOD: 
                case SUBRESOURCE_METHOD: {
                    if (resource.isRootResource()) {
                        JaxrsElementChangedProcessorDelegate.processRootResourceMethodAddition(resourceMethod);
                        break;
                    }
                    JaxrsElementChangedProcessorDelegate.processSubresourceMethodAddition(resourceMethod, metamodel);
                    break;
                }
                case SUBRESOURCE_LOCATOR: {
                    if (!resource.isRootResource()) break;
                    JaxrsElementChangedProcessorDelegate.processSubresourceLocatorAddition(resourceMethod, metamodel);
                    break;
                }
            }
        }
    }

    private static void processAddition(JaxrsResourceElement<?> resourceElement) throws CoreException {
        JaxrsResource resource = resourceElement.getParentResource();
        if (resource == null) {
            Logger.warn("Found an orphan resource element: " + resourceElement);
        } else {
            Set<JaxrsEndpoint> resourceEndpoints = resource.getMetamodel().findEndpoints(resource);
            Flags flags = JaxrsElementChangedProcessorDelegate.computeAnnotationChangeFlags(resourceElement);
            if (flags.hasValue()) {
                for (JaxrsEndpoint endpoint : resourceEndpoints) {
                    endpoint.update(flags);
                }
            }
        }
    }

    private static void processAddition(JaxrsParameterAggregatorElement<?> aggregatorElement, Flags flags) throws CoreException {
        JaxrsParameterAggregator parentAggregator = aggregatorElement.getParentParameterAggregator();
        if (parentAggregator == null) {
            Logger.warn("Found an orphan aggregator element: " + aggregatorElement);
        } else {
            JaxrsElementChangedProcessorDelegate.processCascadeChange(aggregatorElement, parentAggregator, flags);
        }
    }

    private static void processChange(JaxrsParameterAggregatorElement<?> aggregatorElement, Flags flags) throws CoreException {
        JaxrsParameterAggregator parentAggregator = aggregatorElement.getParentParameterAggregator();
        if (parentAggregator == null) {
            Logger.warn("Found an orphan aggregator element: " + aggregatorElement);
        } else {
            JaxrsElementChangedProcessorDelegate.processCascadeChange(aggregatorElement, parentAggregator, flags);
        }
    }

    private static void processRemoval(JaxrsParameterAggregatorElement<?> aggregatorElement, Flags flags) throws CoreException {
        JaxrsParameterAggregator parentAggregator = aggregatorElement.getParentParameterAggregator();
        if (parentAggregator == null) {
            Logger.warn("Found an orphan aggregator element: " + aggregatorElement);
        } else {
            JaxrsElementChangedProcessorDelegate.processCascadeChange(aggregatorElement, parentAggregator, flags);
        }
    }

    public static Flags computeAnnotationChangeFlags(IAnnotatedSourceType changedElement) {
        Flags flags = new Flags();
        for (Map.Entry<String, Annotation> entry : changedElement.getAnnotations().entrySet()) {
            if (entry.getValue().getFullyQualifiedName().equals("javax.ws.rs.QueryParam")) {
                flags.addFlags(1024);
                continue;
            }
            if (entry.getValue().getFullyQualifiedName().equals("javax.ws.rs.MatrixParam")) {
                flags.addFlags(2048);
                continue;
            }
            if (entry.getValue().getFullyQualifiedName().equals("javax.ws.rs.PathParam")) {
                flags.addFlags(512);
                continue;
            }
            if (!entry.getValue().getFullyQualifiedName().equals("javax.ws.rs.BeanParam")) continue;
            flags.addFlags(0x1000000);
        }
        return flags;
    }

    private static void processCascadeChange(IAnnotatedSourceType parameterAggregatorElement, JaxrsParameterAggregator parentAggregator, Flags flags) throws CoreException {
        JaxrsMetamodel metamodel = parentAggregator.getMetamodel();
        List<IType> knownTypes = metamodel.getAllJavaElements(7);
        Set<IType> relatedTypes = JavaElementsSearcher.findRelatedTypes((IType)parentAggregator.getJavaElement(), knownTypes, null);
        HashSet<JaxrsEndpoint> resourceEndpoints = new HashSet<JaxrsEndpoint>();
        for (IType relatedType : relatedTypes) {
            resourceEndpoints.addAll(parentAggregator.getMetamodel().findEndpoints((IJavaElement)relatedType));
        }
        if (flags.hasValue()) {
            for (JaxrsEndpoint endpoint : resourceEndpoints) {
                endpoint.update(flags);
            }
        }
    }

    private static void processRootResourceMethodAddition(JaxrsResourceMethod resourceMethod) throws CoreException {
        JaxrsEndpointFactory.createEndpoints(resourceMethod);
    }

    private static void processSubresourceLocatorAddition(JaxrsResourceMethod subresourceLocator, JaxrsMetamodel metamodel) throws CoreException {
        JaxrsEndpointFactory.createEndpointsFromSubresourceLocator(subresourceLocator);
    }

    private static void processSubresourceMethodAddition(JaxrsResourceMethod resourceMethod, JaxrsMetamodel metamodel) throws CoreException {
        JaxrsEndpointFactory.createEndpointsFromSubresourceMethod(resourceMethod);
    }

    private static void processChange(IJaxrsApplication application, Flags flags) {
        JaxrsMetamodel metamodel = (JaxrsMetamodel)application.getMetamodel();
        if (application.equals(metamodel.findApplication())) {
            for (JaxrsEndpoint endpoint : metamodel.getAllEndpoints()) {
                endpoint.update(application);
            }
        }
    }

    private static void processChange(JaxrsHttpMethod httpMethod, Flags flags) {
        Set<JaxrsEndpoint> endpoints = httpMethod.getMetamodel().findEndpoints(httpMethod);
        for (JaxrsEndpoint endpoint : endpoints) {
            endpoint.update(httpMethod);
        }
    }

    private static void processChange(JaxrsResource resource, Flags flags) throws CoreException {
        if (!flags.hasValue(2)) {
            for (JaxrsResourceMethod resourceMethod : resource.getMethods().values()) {
                JaxrsElementChangedProcessorDelegate.processChange(resourceMethod, flags);
            }
        } else {
            for (JaxrsResourceMethod resourceMethod : resource.getMethods().values()) {
                JaxrsElementChangedProcessorDelegate.processRemoval(resourceMethod);
                JaxrsElementChangedProcessorDelegate.processAddition(resourceMethod);
            }
        }
    }

    private static void processChange(JaxrsResourceMethod changedResourceMethod, Flags flags) throws CoreException {
        JaxrsMetamodel metamodel = changedResourceMethod.getMetamodel();
        if (flags.hasValue(2) || changedResourceMethod.getElementKind() == EnumElementKind.SUBRESOURCE_LOCATOR && flags.hasValue(65536)) {
            metamodel.removeEndpoints(changedResourceMethod);
            JaxrsElementChangedProcessorDelegate.processAddition(changedResourceMethod);
        } else {
            Set<JaxrsEndpoint> endpoints = metamodel.findEndpoints(changedResourceMethod);
            for (JaxrsEndpoint endpoint : endpoints) {
                endpoint.update(changedResourceMethod, flags);
            }
        }
    }

    private static void processChange(JaxrsResourceElement<?> changedResourceElement, Flags flags) throws CoreException {
        JaxrsMetamodel metamodel = changedResourceElement.getMetamodel();
        Set<JaxrsEndpoint> endpoints = metamodel.findEndpoints(changedResourceElement.getParentResource());
        for (JaxrsEndpoint endpoint : endpoints) {
            endpoint.update(flags);
        }
    }

    private static void processRemoval(JaxrsHttpMethod httpMethod) {
        httpMethod.getMetamodel().removeEndpoints(httpMethod);
    }

    private static void processRemoval(IJaxrsApplication application) {
        Set<JaxrsEndpoint> endpoints = ((JaxrsMetamodel)application.getMetamodel()).findEndpoints(application);
        for (JaxrsEndpoint endpoint : endpoints) {
            endpoint.remove(application);
        }
    }

    private static void processRemoval(JaxrsResourceMethod resourceMethod) {
        JaxrsMetamodel metamodel = resourceMethod.getMetamodel();
        if (metamodel != null) {
            metamodel.removeEndpoints(resourceMethod);
        }
    }

    private static void processRemoval(JaxrsResourceElement<?> resourceElement, Flags flags) throws CoreException {
        JaxrsMetamodel metamodel = resourceElement.getMetamodel();
        if (metamodel != null) {
            Set<JaxrsEndpoint> affectedEndpoints = metamodel.findEndpoints(resourceElement.getParentResource());
            if (flags.hasValue()) {
                for (JaxrsEndpoint endpoint : affectedEndpoints) {
                    endpoint.update(flags);
                }
            }
        }
    }
}

