/*
 * Decompiled with CFR 0.152.
 */
package minimatch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import minimatch.Options;
import minimatch.PathAdapter;
import minimatch.internal.StringUtils;
import minimatch.internal.adapters.DefaultPathAdapter;
import minimatch.internal.parser.GlobStar;
import minimatch.internal.parser.LiteralItem;
import minimatch.internal.parser.MagicItem;
import minimatch.internal.parser.ParseContext;
import minimatch.internal.parser.ParseItem;
import minimatch.internal.parser.ParseResult;
import minimatch.internal.parser.PatternListItem;

public class Minimatch {
    private static final GlobStar GLOBSTAR = new GlobStar();
    private final String qmark = "[^/]";
    private final String star = "[^/]*?";
    private final List<Character> reSpecials = StringUtils.asList("().*{}+?[]^$\\!".toCharArray());
    private static final Pattern hasBraces = Pattern.compile("\\{.*\\}");
    protected static final String slashSplit = "/+";
    protected String pattern;
    protected final Options options;
    protected boolean comment;
    protected boolean empty;
    protected boolean negate;
    private List<List<ParseItem>> set;

    public Minimatch(String pattern) {
        this(pattern, null);
    }

    public Minimatch(String pattern, Options options) {
        this.pattern = pattern.trim();
        this.options = Minimatch.getOptions(options);
        if (this.options.isAllowWindowsPaths()) {
            pattern = StringUtils.replacePath(pattern);
        }
        this.negate = false;
        this.comment = false;
        this.empty = false;
        this.make();
    }

    private void make() {
        String pattern = this.pattern;
        Options options = this.options;
        if (!options.isNocomment() && pattern.charAt(0) == '#') {
            this.comment = true;
            return;
        }
        if (pattern == null) {
            this.empty = true;
            return;
        }
        this.parseNegate();
        Object[] set = this.braceExpand(pattern, options);
        String[][] globParts = this.globParts((String[])set);
        if (options.isDebug()) {
            this.debug(this.pattern, set);
        }
        List<List<ParseItem>> results = this.globToRegExps(globParts);
        if (options.isDebug()) {
            this.debug(this.pattern, set);
        }
        this.set = results;
    }

    private String[][] globParts(String[] set) {
        String[][] parts = new String[set.length][];
        for (int i = 0; i < set.length; ++i) {
            parts[i] = set[i].split(slashSplit);
        }
        return parts;
    }

    private List<List<ParseItem>> globToRegExps(String[][] globParts) {
        String[] s = null;
        ArrayList<List<ParseItem>> parts = new ArrayList<List<ParseItem>>();
        ArrayList<ParseItem> p = null;
        for (int i = 0; i < globParts.length; ++i) {
            s = globParts[i];
            p = new ArrayList<ParseItem>();
            parts.add(p);
            for (int j = 0; j < s.length; ++j) {
                p.add(this.parse(s[j], false).getItem());
            }
        }
        return parts;
    }

    private ParseResult parse(String pattern, boolean isSub) {
        Options options = this.options;
        if (!options.isNoglobstar() && "**".equals(pattern)) {
            return new ParseResult(GLOBSTAR, false);
        }
        if (StringUtils.isEmpty(pattern)) {
            return new ParseResult(ParseItem.Empty, false);
        }
        ParseContext ctx = new ParseContext();
        ctx.re = "";
        ctx.hasMagic = options.isNocase();
        boolean escaping = false;
        Stack<PatternListItem> patternListStack = new Stack<PatternListItem>();
        boolean inClass = false;
        int reClassStart = -1;
        int classStart = -1;
        String patternStart = pattern.charAt(0) == '.' ? "" : (options.isDot() ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)");
        block19: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (options.isDebug()) {
                this.debug("%s\t%s %s %j", pattern, i, ctx.re, Character.valueOf(c));
            }
            if (escaping && this.reSpecials.contains(Character.valueOf(c))) {
                ctx.re = ctx.re + (92 + c);
                escaping = false;
                continue;
            }
            switch (c) {
                case '/': {
                    return null;
                }
                case '\\': {
                    this.clearStateChar(ctx);
                    escaping = true;
                    continue block19;
                }
                case '!': 
                case '*': 
                case '+': 
                case '?': 
                case '@': {
                    if (options.isDebug()) {
                        this.debug("%s\t%s %s %j <-- stateChar", pattern, i, ctx.re, Character.valueOf(c));
                    }
                    if (inClass) {
                        if (options.isDebug()) {
                            this.debug("  in class", new Object[0]);
                        }
                        if (c == '!' && i == classStart + 1) {
                            c = '^';
                        }
                        ctx.re = ctx.re + c;
                        continue block19;
                    }
                    if (options.isDebug()) {
                        this.debug("call clearStateChar %j", ctx.stateChar);
                    }
                    this.clearStateChar(ctx);
                    ctx.stateChar = Character.valueOf(c);
                    if (!options.isNoext()) continue block19;
                    this.clearStateChar(ctx);
                    continue block19;
                }
                case '(': {
                    if (inClass) {
                        ctx.re = ctx.re + "(";
                        continue block19;
                    }
                    if (ctx.stateChar == null) {
                        ctx.re = ctx.re + "\\(";
                        continue block19;
                    }
                    char plType = ctx.stateChar.charValue();
                    patternListStack.push(new PatternListItem(plType, i - 1, ctx.re.length()));
                    ctx.re = ctx.re + (ctx.stateChar.charValue() == '!' ? "(?:(?!" : "(?:");
                    if (options.isDebug()) {
                        this.debug("plType %j %j", ctx.stateChar, ctx.re);
                    }
                    ctx.stateChar = null;
                    continue block19;
                }
                case ')': {
                    if (inClass || patternListStack.size() == 0) {
                        ctx.re = ctx.re + "\\)";
                        continue block19;
                    }
                    this.clearStateChar(ctx);
                    ctx.hasMagic = true;
                    ctx.re = ctx.re + ")";
                    char plType = ((PatternListItem)patternListStack.pop()).type;
                    switch (plType) {
                        case '!': {
                            ctx.re = ctx.re + "[^/]*?)";
                            continue block19;
                        }
                        case '*': 
                        case '+': 
                        case '?': {
                            ctx.re = ctx.re + plType;
                            continue block19;
                        }
                    }
                    continue block19;
                }
                case '|': {
                    if (inClass || patternListStack.size() == 0 || escaping) {
                        ctx.re = ctx.re + "\\|";
                        escaping = false;
                        continue block19;
                    }
                    this.clearStateChar(ctx);
                    ctx.re = ctx.re + '|';
                    continue block19;
                }
                case '[': {
                    this.clearStateChar(ctx);
                    if (inClass) {
                        ctx.re = ctx.re + (92 + c);
                        continue block19;
                    }
                    inClass = true;
                    classStart = i;
                    reClassStart = ctx.re.length();
                    ctx.re = ctx.re + c;
                    continue block19;
                }
                case ']': {
                    if (i == classStart + 1 || !inClass) {
                        ctx.re = ctx.re + "\\" + c;
                        escaping = false;
                        continue block19;
                    }
                    if (inClass) {
                        String cs = pattern.substring(classStart + 1, i);
                        try {
                            Pattern.compile("[" + cs + "]");
                        }
                        catch (Throwable e) {
                            ParseResult sp = this.parse(cs, true);
                            ctx.re = ctx.re.substring(0, reClassStart) + "\\[" + sp.getItem() + "\\]";
                            ctx.hasMagic = ctx.hasMagic || sp.isB();
                            inClass = false;
                            continue block19;
                        }
                    }
                    ctx.hasMagic = true;
                    inClass = false;
                    ctx.re = ctx.re + c;
                    continue block19;
                }
                default: {
                    this.clearStateChar(ctx);
                    if (escaping) {
                        escaping = false;
                    } else if (this.reSpecials.contains(Character.valueOf(c)) && (c != '^' || !inClass)) {
                        ctx.re = ctx.re + "\\";
                    }
                    ctx.re = ctx.re + c;
                }
            }
        }
        if (inClass) {
            String cs = pattern.substring(classStart + 1);
            ParseResult sp = this.parse(cs, true);
            ctx.re = ctx.re.substring(0, reClassStart) + "\\[" + sp.getItem();
            boolean bl = ctx.hasMagic = ctx.hasMagic || sp.isB();
        }
        while (!patternListStack.isEmpty()) {
            PatternListItem pl = (PatternListItem)patternListStack.pop();
            String tail = "";
            if (options.isDebug()) {
                this.debug("tail=%j\n   %s", tail, tail);
            }
            String t = "*".equals(Character.valueOf(pl.type)) ? "[^/]*?" : ("?".equals(Character.valueOf(pl.type)) ? "[^/]" : "\\" + pl.type);
            ctx.hasMagic = true;
        }
        this.clearStateChar(ctx);
        if (escaping) {
            ctx.re = ctx.re + "\\\\";
        }
        boolean addPatternStart = false;
        switch (ctx.re.charAt(0)) {
            case '(': 
            case '.': 
            case '[': {
                addPatternStart = true;
            }
        }
        if (!StringUtils.isEmpty(ctx.re) && ctx.hasMagic) {
            ctx.re = "(?=.)" + ctx.re;
        }
        if (addPatternStart) {
            ctx.re = patternStart + ctx.re;
        }
        if (isSub) {
            return new ParseResult(new LiteralItem(ctx.re), ctx.hasMagic);
        }
        if (!ctx.hasMagic) {
            return new ParseResult(new LiteralItem(StringUtils.globUnescape(pattern)), false);
        }
        return new ParseResult(new MagicItem(ctx.re, options), false);
    }

    protected void debug(String pattern, Object ... arguments) {
        this.options.getDebugger().debug(pattern, arguments);
    }

    private void clearStateChar(ParseContext ctx) {
        if (ctx.stateChar != null) {
            switch (ctx.stateChar.charValue()) {
                case '*': {
                    ctx.re = ctx.re + "[^/]*?";
                    ctx.hasMagic = true;
                    break;
                }
                case '?': {
                    ctx.re = ctx.re + "[^/]";
                    ctx.hasMagic = true;
                    break;
                }
                default: {
                    ctx.re = ctx.re + "\\" + ctx.stateChar;
                }
            }
            ctx.stateChar = null;
        }
    }

    private void parseNegate() {
        String pattern = this.pattern;
        boolean negate = false;
        Options options = this.options;
        int negateOffset = 0;
        if (options.isNonegate()) {
            return;
        }
        int l = pattern.length();
        for (int i = 0; i < l && pattern.charAt(i) == '!'; ++i) {
            negate = !negate;
            ++negateOffset;
        }
        if (negateOffset > 0) {
            this.pattern = pattern.substring(negateOffset);
        }
        this.negate = negate;
    }

    private String[] braceExpand(String pattern, Options options) {
        if (options.isNobrace() || !StringUtils.matches(hasBraces, pattern)) {
            return new String[]{pattern};
        }
        return this.expand(pattern);
    }

    private String[] expand(String pattern) {
        return null;
    }

    public <T> boolean match(T f, PathAdapter<T> adapter) {
        return this.match(f, adapter, false);
    }

    public <T> boolean match(T f, PathAdapter<T> adapter, boolean partial) {
        int i;
        Options options = this.options;
        if (options.isDebug()) {
            this.debug(this.pattern, "split", f);
        }
        List<List<ParseItem>> set = this.set;
        if (options.isDebug()) {
            this.debug(this.pattern, "set", set);
        }
        String filename = null;
        for (i = adapter.getLength(f) - 1; i >= 0 && StringUtils.isEmpty(filename = adapter.getPathName(f, i)); --i) {
        }
        for (i = 0; i < set.size(); ++i) {
            boolean hit;
            List<ParseItem> pattern = set.get(i);
            T file = f;
            if (options.isMatchBase() && pattern.size() == 1) {
                file = adapter.createPath(filename);
            }
            if (!(hit = this.matchOne(file, adapter, pattern, partial))) continue;
            if (options.isFlipNegate()) {
                return true;
            }
            return !this.negate;
        }
        if (options.isFlipNegate()) {
            return false;
        }
        return this.negate;
    }

    protected static Options getOptions(Options options) {
        return options == null ? Options.DEFAULT : options;
    }

    private <T> boolean matchOne(T file, PathAdapter<T> adapter, List<ParseItem> pattern, boolean partial) {
        int pi;
        Options options = this.options;
        if (options.isDebug()) {
            this.debug("matchOne", adapter.getLength(file), pattern.size());
        }
        int fi = 0;
        int fl = adapter.getLength(file);
        int pl = pattern.size();
        for (pi = 0; fi < fl && pi < pl; ++fi, ++pi) {
            if (options.isDebug()) {
                this.debug("matchOne loop", new Object[0]);
            }
            ParseItem p = pattern.get(pi);
            String f = adapter.getPathName(file, fi);
            if (p == null) {
                return false;
            }
            if (p instanceof GlobStar) {
                int fr;
                int pr;
                if (options.isDebug()) {
                    this.debug("GLOBSTAR", pattern, p, f);
                }
                if ((pr = pi + 1) == pl) {
                    if (options.isDebug()) {
                        this.debug("** at the end", new Object[0]);
                    }
                    while (fi < fl) {
                        String fileitem = adapter.getPathName(file, fi);
                        if (fileitem.equals(".") || fileitem.equals("..") || !options.isDot() && fileitem.charAt(0) == '.') {
                            return false;
                        }
                        ++fi;
                    }
                    return true;
                }
                for (fr = fi; fr < fl; ++fr) {
                    String swallowee = adapter.getPathName(file, fr);
                    if (options.isDebug()) {
                        this.debug("\nglobstar while", file, fr, pattern, pr, swallowee);
                    }
                    if (this.matchOne(adapter.subPath(file, fr), adapter, pattern.subList(pr, pattern.size()), partial)) {
                        if (options.isDebug()) {
                            this.debug("globstar found match!", fr, fl, swallowee);
                        }
                        return true;
                    }
                    if (swallowee.equals(".") || swallowee.equals("..") || !options.isDot() && swallowee.charAt(0) == '.') {
                        if (!options.isDebug()) break;
                        this.debug("dot detected!", file, fr, pattern, pr);
                        break;
                    }
                    if (!options.isDebug()) continue;
                    this.debug("globstar swallow a segment, and continue", new Object[0]);
                }
                if (partial) {
                    if (options.isDebug()) {
                        this.debug("\n>>> no match, partial?", file, fr, pattern, pr);
                    }
                    if (fr == fl) {
                        return true;
                    }
                }
                return false;
            }
            if (p.match(f, options)) continue;
            return false;
        }
        if (fi == fl && pi == pl) {
            return true;
        }
        if (fi == fl) {
            return partial;
        }
        if (pi == pl) {
            boolean emptyFileEnd = fi == fl - 1 && adapter.getPathName(file, fi).equals("");
            return emptyFileEnd;
        }
        throw new IllegalStateException("wtf?");
    }

    public static boolean minimatch(String p, String pattern) {
        return Minimatch.minimatch(p, pattern, null);
    }

    public static boolean minimatch(String p, String pattern, Options options) {
        if ((options = Minimatch.getOptions(options)) == null) {
            options = Options.DEFAULT;
        }
        if (!options.isNocomment() && pattern.charAt(0) == '#') {
            return false;
        }
        if (StringUtils.isEmpty(pattern.trim())) {
            return "".equals(p);
        }
        return new Minimatch(pattern, options).match(p);
    }

    public boolean match(String p) {
        return this.match(p, false);
    }

    public boolean match(String input, boolean partial) {
        if (this.options.isDebug()) {
            this.debug("match", input, this.pattern);
        }
        if (this.comment) {
            return false;
        }
        if (this.empty) {
            return StringUtils.isEmpty(input);
        }
        if ("/".equals(input) && partial) {
            return true;
        }
        Options options = this.options;
        if (options.isAllowWindowsPaths()) {
            input = StringUtils.replacePath(input);
        }
        List<String> f = Arrays.asList(input.split(slashSplit));
        return this.match(f, DefaultPathAdapter.INSTANCE, partial);
    }
}

