/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.validation;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JavaMethodSignature;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsProvider;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJavaMethodParameter;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsJavaApplication;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResource;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.AbstractJaxrsElementValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.IMarkerManager;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsValidationMessages;
import org.jboss.tools.ws.jaxrs.ui.preferences.JaxrsPreferences;

public class JaxrsProviderValidatorDelegate
extends AbstractJaxrsElementValidatorDelegate<JaxrsProvider> {
    public JaxrsProviderValidatorDelegate(IMarkerManager markerManager) {
        super(markerManager);
    }

    @Override
    void internalValidate(JaxrsProvider provider, CompilationUnit ast) throws CoreException {
        Logger.debug("Validating element {}", provider);
        this.validateAtLeastOneValidConstructor(provider, ast);
        this.validateNoMissingProviderAnnotation(provider);
        this.validateNoDuplicateProvider(provider);
        this.validateAtLeastOneImplementation(provider);
        this.validatePreMatchingOnContainerRequestFilterOnly(provider);
        this.validateAtLeastOneResourceOrResourceMethodWithBinding(provider);
    }

    private void validateAtLeastOneResourceOrResourceMethodWithBinding(JaxrsProvider provider) throws CoreException {
        if (provider == null) {
            return;
        }
        Map nameBindingAnnotations = provider.getNameBindingAnnotations();
        if (nameBindingAnnotations.isEmpty()) {
            return;
        }
        JaxrsMetamodel metamodel = provider.getMetamodel();
        String firstNameBindingAnnotationClassName = (String)nameBindingAnnotations.keySet().iterator().next();
        Set allBindingAnnotationNames = nameBindingAnnotations.keySet();
        Set annotatedResourceMethods = metamodel.findResourceMethodsByAnnotation(firstNameBindingAnnotationClassName);
        for (IJaxrsResourceMethod resourceMethod : annotatedResourceMethods) {
            if (!resourceMethod.getNameBindingAnnotations().keySet().containsAll(allBindingAnnotationNames)) continue;
            return;
        }
        Set annotatedResources = metamodel.findResourcesByAnnotation(firstNameBindingAnnotationClassName);
        for (IJaxrsResource resource : annotatedResources) {
            if (!resource.getNameBindingAnnotations().keySet().containsAll(allBindingAnnotationNames)) continue;
            return;
        }
        Set annotatedApplications = metamodel.findApplicationsByAnnotation(firstNameBindingAnnotationClassName);
        for (IJaxrsJavaApplication application : annotatedApplications) {
            if (!application.getNameBindingAnnotations().keySet().containsAll(allBindingAnnotationNames)) continue;
            return;
        }
        ISourceRange nameRange = ((Annotation)nameBindingAnnotations.get(firstNameBindingAnnotationClassName)).getJavaAnnotation().getNameRange();
        this.markerManager.addMarker((JaxrsBaseElement)provider, nameRange, JaxrsValidationMessages.PROVIDER_UNUSED_BINDING, new String[0], JaxrsPreferences.PROVIDER_UNUSED_BINDING);
    }

    private void validatePreMatchingOnContainerRequestFilterOnly(JaxrsProvider provider) throws CoreException {
        Annotation preMatchingAnntotation;
        if (provider != null && !provider.getProvidedTypes().containsKey(EnumElementKind.CONTAINER_REQUEST_FILTER) && (preMatchingAnntotation = provider.getAnnotation("javax.ws.rs.container.PreMatching")) != null) {
            ISourceRange nameRange = preMatchingAnntotation.getJavaAnnotation().getNameRange();
            this.markerManager.addMarker((JaxrsBaseElement)provider, nameRange, JaxrsValidationMessages.PROVIDER_INVALID_PRE_MATCHING_ANNOTATION_USAGE, new String[0], JaxrsPreferences.PROVIDER_INVALID_PRE_MATCHING_ANNOTATION_USAGE);
        }
    }

    private void validateAtLeastOneValidConstructor(JaxrsProvider provider, CompilationUnit ast) throws CoreException {
        IType providerType = (IType)provider.getJavaElement();
        IMethod[] methods = providerType.getMethods();
        int validConstructorsCounter = 0;
        boolean hasConstructors = false;
        IMethod[] iMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (JaxrsProviderValidatorDelegate.isContructor(method)) {
                hasConstructors = true;
                if (JaxrsProviderValidatorDelegate.isValidConstructor(method, ast)) {
                    ++validConstructorsCounter;
                }
            }
            ++n2;
        }
        if (hasConstructors && validConstructorsCounter == 0) {
            ISourceRange nameRange = providerType.getNameRange();
            this.markerManager.addMarker((JaxrsBaseElement)provider, nameRange, JaxrsValidationMessages.PROVIDER_MISSING_VALID_CONSTRUCTOR, new String[0], JaxrsPreferences.PROVIDER_MISSING_VALID_CONSTRUCTOR);
        }
    }

    private static boolean isContructor(IMethod method) {
        return method.getElementName().equals(method.getParent().getElementName());
    }

    private static boolean isValidConstructor(IMethod method, CompilationUnit ast) throws JavaModelException {
        if ((method.getFlags() & 1) == 0) {
            return false;
        }
        ILocalVariable[] parameters = method.getParameters();
        if (parameters.length == 0) {
            return true;
        }
        JavaMethodSignature methodSignature = JdtUtils.resolveMethodSignature((IMethod)method, (CompilationUnit)ast);
        if (methodSignature != null) {
            for (IJavaMethodParameter parameter : methodSignature.getMethodParameters()) {
                if (parameter.getAnnotations().isEmpty()) {
                    return false;
                }
                for (Map.Entry annotation : parameter.getAnnotations().entrySet()) {
                    if (((Annotation)annotation.getValue()).getFullyQualifiedName().equals("javax.ws.rs.core.Context") && (parameter.getType() == null || CONTEXT_TYPE_NAMES.contains(parameter.getType().getErasureName()))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void validateAtLeastOneImplementation(JaxrsProvider provider) throws CoreException {
        if (provider.getProvidedTypes().size() == 0) {
            ISourceRange nameRange = ((IType)provider.getJavaElement()).getNameRange();
            this.markerManager.addMarker((JaxrsBaseElement)provider, nameRange, JaxrsValidationMessages.PROVIDER_MISSING_IMPLEMENTATION, new String[0], JaxrsPreferences.PROVIDER_MISSING_IMPLEMENTATION);
        }
    }

    private void validateNoMissingProviderAnnotation(JaxrsProvider provider) throws CoreException {
        Annotation annotation = provider.getAnnotation("javax.ws.rs.ext.Provider");
        if (annotation == null) {
            ISourceRange nameRange = ((IType)provider.getJavaElement()).getNameRange();
            this.markerManager.addMarker((JaxrsBaseElement)provider, nameRange, JaxrsValidationMessages.PROVIDER_MISSING_ANNOTATION, new String[0], JaxrsPreferences.PROVIDER_MISSING_ANNOTATION);
        }
    }

    private void validateNoDuplicateProvider(JaxrsProvider provider) throws CoreException {
        JaxrsMetamodel metamodel = provider.getMetamodel();
        for (Map.Entry entry : provider.getProvidedTypes().entrySet()) {
            EnumElementKind elementKind = (EnumElementKind)entry.getKey();
            IType providedType = provider.getProvidedType(elementKind);
            if (providedType == null) {
                return;
            }
            Set providers = metamodel.findProviders(elementKind, providedType.getFullyQualifiedName());
            for (JaxrsProvider p : providers) {
                if (p == provider || !provider.collidesWith(p, elementKind)) continue;
                switch (elementKind) {
                    case MESSAGE_BODY_READER: {
                        this.addDuplicateProviderProblem(provider, providedType, JaxrsValidationMessages.PROVIDER_DUPLICATE_MESSAGE_BODY_READER, JaxrsPreferences.PROVIDER_DUPLICATE_MESSAGE_BODY_READER);
                        break;
                    }
                    case MESSAGE_BODY_WRITER: {
                        this.addDuplicateProviderProblem(provider, providedType, JaxrsValidationMessages.PROVIDER_DUPLICATE_MESSAGE_BODY_WRITER, JaxrsPreferences.PROVIDER_DUPLICATE_MESSAGE_BODY_WRITER);
                        break;
                    }
                    case EXCEPTION_MAPPER: {
                        this.addDuplicateProviderProblem(provider, providedType, JaxrsValidationMessages.PROVIDER_DUPLICATE_EXCEPTION_MAPPER, JaxrsPreferences.PROVIDER_DUPLICATE_EXCEPTION_MAPPER);
                    }
                }
            }
        }
    }

    private void addDuplicateProviderProblem(JaxrsProvider provider, IType providedType, String message, String preferenceKey) throws CoreException {
        ISourceRange nameRange = this.getTypeParameterNameRange((IType)provider.getJavaElement(), providedType);
        this.markerManager.addMarker((JaxrsBaseElement)provider, nameRange, message, new String[]{((IType)provider.getJavaElement()).getFullyQualifiedName()}, preferenceKey);
    }

    private ISourceRange getTypeParameterNameRange(IType type, IType parameterType) throws JavaModelException {
        if (type.getTypeParameter(parameterType.getElementName()).exists()) {
            return type.getTypeParameter(parameterType.getElementName()).getNameRange();
        }
        if (type.getTypeParameter(parameterType.getFullyQualifiedName()).exists()) {
            return type.getTypeParameter(parameterType.getFullyQualifiedName()).getNameRange();
        }
        return type.getNameRange();
    }
}

