/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocBrowserInformationControlInput;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.ui.contentassist.MemberDeclarationVisitor;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.osgi.framework.Bundle;

public class BasicCompletionProposal
implements IJavaCompletionProposal {
    private final ICompilationUnit compilationUnit;
    public static final int MAX_RELEVANCE = 1000;
    private String additionalProposalInfo;
    private final IMember member;
    private final String replacementString;
    private final int replacementOffset;
    private final int replacementLength;
    private final Image icon;
    private final String proposalDisplayString;
    private final int relevance;
    private String fgCSSStyles;
    private String additionalImport;

    public BasicCompletionProposal(ICompilationUnit compilationUnit, String replacementString, String proposalDisplayString, int replacementOffset, int replacementLength, Image icon, IMember member) {
        this.compilationUnit = compilationUnit;
        this.replacementString = replacementString;
        this.replacementOffset = replacementOffset;
        this.replacementLength = replacementLength;
        this.icon = icon;
        this.proposalDisplayString = proposalDisplayString;
        this.relevance = 1000;
        this.member = member;
    }

    protected void includeImportDeclarationAddition(String fullyQualifiedName) {
        this.additionalImport = fullyQualifiedName;
    }

    public int getReplacementOffset() {
        return this.replacementOffset;
    }

    public int getReplacementLength() {
        return this.replacementLength;
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public Point getSelection(IDocument document) {
        return new Point(this.replacementOffset + this.replacementString.length(), 0);
    }

    public void apply(IDocument document) {
        this.apply(document, '\u0000', 0);
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            document.replace(this.replacementOffset, this.replacementLength, this.replacementString);
            IImportContainer importContainer = this.compilationUnit.getImportContainer();
            if (this.additionalImport != null && !importContainer.getImport(this.additionalImport).exists()) {
                ISourceRange importContainerRange = importContainer.getSourceRange();
                document.replace(importContainerRange.getOffset() + importContainerRange.getLength(), 0, String.valueOf(document.getLineDelimiter(0)) + "import " + this.additionalImport + ";");
            }
        }
        catch (BadLocationException e) {
            Logger.warn("Failed to replace document content with selected proposal", e);
        }
        catch (JavaModelException e) {
            Logger.warn("Failed to replace document content with selected proposal", e);
        }
    }

    public String getAdditionalProposalInfo() {
        if (this.additionalProposalInfo == null) {
            this.additionalProposalInfo = ((JavadocBrowserInformationControlInput)this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor())).getHtml();
        }
        if (this.additionalProposalInfo != null) {
            return this.additionalProposalInfo.toString();
        }
        return null;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        if (this.member != null) {
            try {
                CompilationUnit compilationUnit = JdtUtils.parse((IJavaElement)this.member, (IProgressMonitor)monitor);
                MemberDeclarationVisitor memberDeclarationVisitor = new MemberDeclarationVisitor(this.member);
                compilationUnit.accept((ASTVisitor)memberDeclarationVisitor);
                String sourceOverview = memberDeclarationVisitor.getSourceOverview();
                StringBuffer buffer = new StringBuffer();
                HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)this.getCSSStyles());
                buffer.append("Matching URI Template mapping defined in the <strong>@Path</strong> annotation value below:</br></br>");
                buffer.append(sourceOverview.replaceFirst("@Path.*\n", "<strong>$0</strong>").replaceAll("\n", "<br/>").replaceAll("\t", "  ").replaceAll("<br/>\\s*", "<br/>"));
                HTMLPrinter.addPageEpilog((StringBuffer)buffer);
                this.additionalProposalInfo = buffer.toString();
                return new JavadocBrowserInformationControlInput(null, null, this.additionalProposalInfo, 0);
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    protected String getCSSStyles() {
        String css;
        block17: {
            Bundle bundle;
            URL url;
            if (this.fgCSSStyles == null && (url = (bundle = Platform.getBundle((String)JavaPlugin.getPluginId())).getEntry("/JavadocHoverStyleSheet.css")) != null) {
                BufferedReader reader = null;
                try {
                    try {
                        url = FileLocator.toFileURL((URL)url);
                        reader = new BufferedReader(new InputStreamReader(url.openStream()));
                        StringBuffer buffer = new StringBuffer(200);
                        String line = reader.readLine();
                        while (line != null) {
                            buffer.append(line);
                            buffer.append('\n');
                            line = reader.readLine();
                        }
                        this.fgCSSStyles = buffer.toString();
                    }
                    catch (IOException ex) {
                        JavaPlugin.log((Throwable)ex);
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            break block17;
                        }
                        catch (IOException iOException) {}
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if ((css = this.fgCSSStyles) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    public String getDisplayString() {
        if (this.proposalDisplayString != null) {
            return this.proposalDisplayString;
        }
        return null;
    }

    public Image getImage() {
        return this.icon;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return this.relevance;
    }
}

