/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.util;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.Platform;

public class PlatformUtil {
    private static final String SWT_GTK3 = "SWT_GTK3";
    private static final String MAC = "mac";
    private static final String DARWIN = "darwin";
    private static final String WIN = "win";
    private static final String LINUX = "nux";
    private static OS detectedOs;

    public static boolean isWindows() {
        return OS.WINDOWS.equals((Object)PlatformUtil.getOs());
    }

    public static boolean isMacOS() {
        return OS.MACOS.equals((Object)PlatformUtil.getOs());
    }

    public static boolean isLinux() {
        return OS.LINUX.equals((Object)PlatformUtil.getOs());
    }

    public static OS getOs() {
        if (detectedOs == null) {
            String currentOs = System.getProperty("os.name", "generic").toLowerCase();
            detectedOs = currentOs.indexOf(MAC) >= 0 || currentOs.indexOf(DARWIN) >= 0 ? OS.MACOS : (currentOs.indexOf(WIN) >= 0 ? OS.WINDOWS : (currentOs.indexOf(LINUX) >= 0 ? OS.LINUX : OS.OTHER));
        }
        return detectedOs;
    }

    public static boolean isGTK3() {
        if ("gtk".equals(Platform.getWS())) {
            try {
                Class<?> clazz = Class.forName("org.eclipse.swt.internal.gtk.OS");
                Field field = clazz.getDeclaredField("GTK3");
                boolean gtk3 = field.getBoolean(field);
                return gtk3;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return PlatformUtil.isGTK3Env();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return false;
            }
            catch (SecurityException securityException) {
                return PlatformUtil.isGTK3Env();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return PlatformUtil.isGTK3Env();
            }
            catch (IllegalAccessException illegalAccessException) {
                return PlatformUtil.isGTK3Env();
            }
        }
        return false;
    }

    private static boolean isGTK3Env() {
        String gtk3 = System.getProperty(SWT_GTK3);
        if (gtk3 == null) {
            gtk3 = System.getenv(SWT_GTK3);
        }
        return !"0".equals(gtk3);
    }

    public static enum OS {
        WINDOWS,
        MACOS,
        LINUX,
        OTHER;

    }
}

