/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.modules;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.modules.SingleDeployableFactory;

public class SingleDeployableWorkspaceListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private IModule[] changedMods;

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 4) {
            IProject project = (IProject)event.getResource();
            ArrayList<IModule> shouldChange = new ArrayList<IModule>();
            IModule[] allMods = SingleDeployableFactory.getFactory().getModules();
            int i = 0;
            while (i < allMods.length) {
                if (allMods[i].getProject().equals((Object)project)) {
                    shouldChange.add(allMods[i]);
                }
                ++i;
            }
            this.changedMods = shouldChange.toArray(new IModule[shouldChange.size()]);
        } else {
            try {
                if (event.getDelta() != null) {
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException ce) {
                JBossServerCorePlugin.log(ce.getStatus());
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource instanceof IWorkspaceRoot) {
            return true;
        }
        if (resource instanceof IProject) {
            this.processProjectDelta((IProject)resource, delta);
        }
        return false;
    }

    protected void processProjectDelta(IProject resource, IResourceDelta delta) {
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if (kind == 1 && this.hasRenamedAddedFlags(flags)) {
            this.processRename(resource, this.changedMods);
        }
    }

    private void processRename(final IProject project, final IModule[] changedMods) {
        WorkspaceJob job = new WorkspaceJob("Renaming a project with deployable artifacts"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                SingleDeployableWorkspaceListener.this.processRename2(project, changedMods);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return "org.eclipse.jst.j2ee.refactor.project".equals(family);
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }

    private void processRename2(IProject project, IModule[] changedMods) {
        IPath[] paths = new IPath[changedMods.length];
        IPath[] paths2 = new IPath[changedMods.length];
        int i = 0;
        while (i < changedMods.length) {
            SingleDeployableFactory.SingleDeployableModuleDelegate del = (SingleDeployableFactory.SingleDeployableModuleDelegate)((Object)changedMods[i].loadAdapter(SingleDeployableFactory.SingleDeployableModuleDelegate.class, null));
            paths[i] = del.getWorkspaceRelativePath();
            paths2[i] = new Path(project.getName()).append(del.getWorkspaceRelativePath().removeFirstSegments(1));
            ++i;
        }
        SingleDeployableFactory.makeDeployable(project, paths2);
        IServer[] allServers = ServerCore.getServers();
        int i2 = 0;
        while (i2 < allServers.length) {
            ArrayList<IModule> toAdd = new ArrayList<IModule>();
            ArrayList<IModule> toRemove = new ArrayList<IModule>();
            IModule[] modsOnServer = allServers[i2].getModules();
            int j = 0;
            while (j < modsOnServer.length) {
                int k = 0;
                while (k < changedMods.length) {
                    if (changedMods[k].getId().equals(modsOnServer[j].getId())) {
                        toRemove.add(changedMods[k]);
                        toAdd.add(SingleDeployableFactory.findModule(paths2[k]));
                    }
                    ++k;
                }
                ++j;
            }
            if (toAdd.size() > 0 && toRemove.size() > 0) {
                IServerWorkingCopy wc = allServers[i2].createWorkingCopy();
                try {
                    wc.createWorkingCopy().modifyModules(toAdd.toArray(new IModule[toAdd.size()]), toRemove.toArray(new IModule[toRemove.size()]), (IProgressMonitor)new NullProgressMonitor());
                    wc.save(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException ce) {
                    JBossServerCorePlugin.log(ce.getStatus());
                }
            }
            ++i2;
        }
    }

    private boolean hasRenamedAddedFlags(int flags) {
        return (flags & 0x80000) > 0 && (flags & 0x1000) > 0;
    }
}

