/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.core.resolver;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.el.core.ELCorePlugin;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELResolverFactory;
import org.jboss.tools.common.el.core.resolver.TestELResolverFactory;

public class ELResolverFactoryManager {
    private static final ELResolverFactoryManager INSTANCE = new ELResolverFactoryManager();
    static HashMap<String, Set<ELResolver>> resolversByNature;
    static Set<ELResolverFactory> resolverFactories;

    private ELResolverFactoryManager() {
    }

    public static ELResolverFactoryManager getInstance() {
        return INSTANCE;
    }

    private synchronized void init() {
        if (resolversByNature == null) {
            resolversByNature = new HashMap();
            resolverFactories = new HashSet<ELResolverFactory>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.jboss.tools.common.el.core.elResolver");
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement[] natures = elements[j].getChildren("project-nature");
                    int k = 0;
                    while (k < natures.length) {
                        String natureId = natures[k].getAttribute("id");
                        try {
                            Object resolver = natures[k].createExecutableExtension("resolver-class");
                            if (resolver instanceof ELResolver) {
                                Set<ELResolver> resolverSet = resolversByNature.get(natureId);
                                if (resolverSet == null) {
                                    resolverSet = new HashSet<ELResolver>();
                                    resolversByNature.put(natureId, resolverSet);
                                }
                                resolverSet.add((ELResolver)resolver);
                            } else {
                                ELCorePlugin.getPluginLog().logError(String.valueOf(resolver.getClass().getName()) + " must be instance of org.jboss.tools.common.el.core.resolver.ELResolver");
                            }
                        }
                        catch (CoreException e) {
                            ELCorePlugin.getPluginLog().logError((Throwable)e);
                        }
                        ++k;
                    }
                    IConfigurationElement[] factories = elements[j].getChildren("factory");
                    int k2 = 0;
                    while (k2 < factories.length) {
                        try {
                            Object factory = factories[k2].createExecutableExtension("class");
                            if (factory instanceof ELResolverFactory) {
                                resolverFactories.add((ELResolverFactory)factory);
                            } else if (!(factory instanceof TestELResolverFactory)) {
                                ELCorePlugin.getPluginLog().logError(String.valueOf(factory.getClass().getName()) + " must be instance of org.jboss.tools.common.el.core.resolver.ELResolverFactory");
                            }
                        }
                        catch (CoreException e) {
                            ELCorePlugin.getPluginLog().logError((Throwable)e);
                        }
                        ++k2;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public ELResolver[] getResolvers(IResource resource) {
        if (resource == null || !resource.isAccessible()) {
            return new ELResolver[0];
        }
        IProject project = resource.getProject();
        if (project == null || !project.isAccessible()) {
            return new ELResolver[0];
        }
        this.init();
        HashSet<ELResolver> resolverSet = new HashSet<ELResolver>();
        Set<String> ids = resolversByNature.keySet();
        for (String natureId : ids) {
            try {
                if (!project.hasNature(natureId)) continue;
                resolverSet.addAll((Collection)resolversByNature.get(natureId));
            }
            catch (CoreException e) {
                ELCorePlugin.getPluginLog().logError((Throwable)e);
            }
        }
        for (ELResolverFactory factory : resolverFactories) {
            ELResolver resolver = factory.createResolver(resource);
            if (resolver == null) continue;
            resolverSet.add(resolver);
        }
        return resolverSet.toArray(new ELResolver[resolverSet.size()]);
    }
}

