/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.osgi;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.osgi.Activator;

public class OsgiUIImages {
    private static final String ICON_PATH_PREFIX = "";
    private static final String NAME_PREFIX = "org.springframework.ide.eclipse.osgi.";
    private static final int NAME_PREFIX_LENGTH = "org.springframework.ide.eclipse.osgi.".length();
    private static final String STRUCTURE = "icons/full/obj16/";
    private static URL ICON_BASE_URL = null;
    private static Map<String, ImageDescriptor> imageDescriptors;
    private static ImageRegistry imageRegistry;
    public static final String IMG_OBJS_OSGI = "org.springframework.ide.eclipse.osgi.spring_osgi_obj.gif";
    public static final String IMG_BLUEPRINT_OBJS_OSGI = "org.springframework.ide.eclipse.osgi.blueprint_obj.gif";
    public static final String IMG_SERVICE_OBJS_OSGI = "org.springframework.ide.eclipse.osgi.service_obj.gif";
    public static final String IMG_COMPONENT_OBJS_OSGI = "org.springframework.ide.eclipse.osgi.component_obj.gif";
    public static final String IMG_REFERENCE_OBJS_OSGI = "org.springframework.ide.eclipse.osgi.reference_obj.gif";
    public static final ImageDescriptor DESC_OBJS_OSGI;
    public static final ImageDescriptor DESC_BLUEPRINT_OBJS_OSGI;
    public static final ImageDescriptor DESC_SERVICE_OBJS_OSGI;
    public static final ImageDescriptor DESC_REFERENCE_OBJS_OSGI;
    public static final ImageDescriptor DESC_COMPONENT_OBJS_OSGI;

    static {
        try {
            ICON_BASE_URL = new URL(Activator.getDefault().getBundle().getEntry("/"), ICON_PATH_PREFIX);
        }
        catch (MalformedURLException malformedURLException) {}
        DESC_OBJS_OSGI = OsgiUIImages.createManaged(STRUCTURE, IMG_OBJS_OSGI);
        DESC_BLUEPRINT_OBJS_OSGI = OsgiUIImages.createManaged(STRUCTURE, IMG_BLUEPRINT_OBJS_OSGI);
        DESC_SERVICE_OBJS_OSGI = OsgiUIImages.createManaged(STRUCTURE, IMG_SERVICE_OBJS_OSGI);
        DESC_REFERENCE_OBJS_OSGI = OsgiUIImages.createManaged(STRUCTURE, IMG_REFERENCE_OBJS_OSGI);
        DESC_COMPONENT_OBJS_OSGI = OsgiUIImages.createManaged(STRUCTURE, IMG_COMPONENT_OBJS_OSGI);
    }

    public static Image getImage(String key) {
        return OsgiUIImages.getImageRegistry().get(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        OsgiUIImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        OsgiUIImages.setImageDescriptors(action, "lcl16", iconName);
    }

    static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
            for (String key : imageDescriptors.keySet()) {
                imageRegistry.put(key, imageDescriptors.get(key));
            }
            imageDescriptors = null;
        }
        return imageRegistry;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)OsgiUIImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        action.setImageDescriptor(OsgiUIImages.create("e" + type, relPath));
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)OsgiUIImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (imageDescriptors == null) {
                imageDescriptors = new HashMap<String, ImageDescriptor>();
            }
            imageDescriptors.put(name, result);
            return result;
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)OsgiUIImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(ICON_BASE_URL, buffer.toString());
    }
}

