/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.navigator.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.util.AopReferenceModelUtils;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AbstractJavaElementReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdviceAopTargetNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdvisedAopTargetBeanNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IRevealableReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.util.AopReferenceModelNavigatorUtils;

public class MethodBeanReferenceNode
extends AbstractJavaElementReferenceNode
implements IReferenceNode,
IRevealableReferenceNode {
    private List<IAopReference> aspectReferences = new ArrayList<IAopReference>();
    private List<IAopReference> adviseReferences = new ArrayList<IAopReference>();

    public MethodBeanReferenceNode(IMember member, List<IAopReference> aspectReferences, List<IAopReference> adviseReferences) {
        super(member);
        this.aspectReferences = aspectReferences;
        this.adviseReferences = adviseReferences;
    }

    @Override
    public IReferenceNode[] getChildren() {
        ArrayList<IAopReference> ref;
        HashMap refs;
        ArrayList<IRevealableReferenceNode> nodes = new ArrayList<IRevealableReferenceNode>();
        if (this.aspectReferences.size() > 0) {
            refs = new HashMap();
            for (IAopReference iAopReference : this.aspectReferences) {
                if (refs.containsKey(iAopReference.getDefinition())) {
                    ((List)refs.get(iAopReference.getDefinition())).add(iAopReference);
                    continue;
                }
                ref = new ArrayList<IAopReference>();
                ref.add(iAopReference);
                refs.put(iAopReference.getDefinition(), ref);
            }
            for (Map.Entry entry : refs.entrySet()) {
                nodes.add(new AdviceAopTargetNode((List)entry.getValue()));
            }
        }
        if (this.adviseReferences.size() > 0) {
            refs = new HashMap();
            for (IAopReference iAopReference : this.adviseReferences) {
                if (refs.containsKey(iAopReference.getTargetBeanId())) {
                    ((List)refs.get(iAopReference.getTargetBeanId())).add(iAopReference);
                    continue;
                }
                ref = new ArrayList();
                ref.add(iAopReference);
                refs.put(iAopReference.getTargetBeanId(), ref);
            }
            for (Map.Entry entry : refs.entrySet()) {
                nodes.add(new AdvisedAopTargetBeanNode((List)entry.getValue()));
            }
        }
        return nodes.toArray(new IReferenceNode[nodes.size()]);
    }

    @Override
    public String getText() {
        if (this.element instanceof IType) {
            return String.valueOf(AopReferenceModelNavigatorUtils.JAVA_LABEL_PROVIDER.getText((Object)this.element)) + " - " + AopReferenceModelUtils.getPackageLinkName((IJavaElement)this.element);
        }
        return AopReferenceModelNavigatorUtils.JAVA_LABEL_PROVIDER.getText((Object)this.element);
    }

    @Override
    public boolean hasChildren() {
        return this.aspectReferences.size() > 0 || this.adviseReferences.size() > 0;
    }
}

