/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.views;

import com.atlassian.connector.eclipse.internal.bamboo.ui.BambooImages;
import com.atlassian.connector.eclipse.internal.bamboo.ui.views.ITraceDisplay;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class FailureTableDisplay
implements ITraceDisplay {
    private final Table fTable;
    private final Image fExceptionIcon = BambooImages.getImageDescriptor("obj16/exc_catch.gif").createImage();
    private final Image fStackIcon = BambooImages.getImageDescriptor("obj16/stkfrm_obj.gif").createImage();

    public FailureTableDisplay(Table table) {
        this.fTable = table;
        this.fTable.getParent().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FailureTableDisplay.this.disposeIcons();
            }
        });
    }

    public void addTraceLine(int lineType, String label) {
        TableItem tableItem = this.newTableItem();
        switch (lineType) {
            case 1: {
                tableItem.setImage(this.fExceptionIcon);
                break;
            }
            case 2: {
                tableItem.setImage(this.fStackIcon);
                break;
            }
        }
        tableItem.setText(label);
    }

    public Image getExceptionIcon() {
        return this.fExceptionIcon;
    }

    public Image getStackIcon() {
        return this.fStackIcon;
    }

    public Table getTable() {
        return this.fTable;
    }

    private void disposeIcons() {
        if (this.fExceptionIcon != null && !this.fExceptionIcon.isDisposed()) {
            this.fExceptionIcon.dispose();
        }
        if (this.fStackIcon != null && !this.fStackIcon.isDisposed()) {
            this.fStackIcon.dispose();
        }
    }

    TableItem newTableItem() {
        return new TableItem(this.fTable, 0);
    }
}

