/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.actions;

import com.atlassian.connector.eclipse.internal.bamboo.ui.BambooImages;
import com.atlassian.theplugin.commons.util.MiscUtil;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class RepositoryConfigurationAction
extends Action
implements IMenuCreator {
    private static final String ADD_TASK_REPOSITORY_COMMAND = "org.eclipse.mylyn.tasks.ui.command.addTaskRepository";
    private Menu menu;

    public RepositoryConfigurationAction() {
        this.initialize();
    }

    private void initialize() {
        this.setText("Add Bamboo Repository...");
        this.setImageDescriptor(BambooImages.ADD_REPOSITORY);
    }

    public void run() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                RepositoryConfigurationAction.this.openNewRepositoryWizard();
            }
        });
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        this.addActions();
        return this.menu;
    }

    private void openNewRepositoryWizard() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        Command addTaskRepositoryCommand = commandService.getCommand(ADD_TASK_REPOSITORY_COMMAND);
        HashMap parameters = MiscUtil.buildHashMap();
        parameters.put("connectorKind", "bamboo");
        try {
            addTaskRepositoryCommand.executeWithChecks(new ExecutionEvent(addTaskRepositoryCommand, (Map)parameters, null, (Object)handlerService.getCurrentState()));
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.bamboo.core", NLS.bind((String)"Failed to execute {0} command.", (Object)ADD_TASK_REPOSITORY_COMMAND), (Throwable)e));
        }
    }

    private void addActions() {
        Action addRepositoryAction = new Action(){

            public void run() {
                RepositoryConfigurationAction.this.openNewRepositoryWizard();
            }
        };
        ActionContributionItem addRepoACI = new ActionContributionItem((IAction)addRepositoryAction);
        addRepositoryAction.setText("Add New Repository...");
        addRepositoryAction.setImageDescriptor(BambooImages.ADD_REPOSITORY);
        addRepoACI.fill(this.menu, -1);
        boolean separatorAdded = false;
        for (final TaskRepository repository : TasksUi.getRepositoryManager().getRepositories("bamboo")) {
            if (!separatorAdded) {
                new Separator().fill(this.menu, -1);
                separatorAdded = true;
            }
            Action openRepositoryConfigurationAction = new Action(){

                public void run() {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            TasksUiUtil.openEditRepositoryWizard((TaskRepository)repository);
                        }
                    });
                }
            };
            ActionContributionItem openRepoConfigACI = new ActionContributionItem((IAction)openRepositoryConfigurationAction);
            openRepositoryConfigurationAction.setText(NLS.bind((String)"Properties for {0}...", (Object)repository.getRepositoryLabel()));
            openRepoConfigACI.fill(this.menu, -1);
        }
        new Separator().fill(this.menu, -1);
        Action gotoTaskRepositoryViewAction = new Action(){

            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.mylyn.tasks.ui.views.repositories");
                        }
                        catch (PartInitException partInitException) {
                            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.bamboo.ui", "Failed to show Repositories View"));
                        }
                    }
                });
            }
        };
        ActionContributionItem gotoRepoViewACI = new ActionContributionItem((IAction)gotoTaskRepositoryViewAction);
        gotoTaskRepositoryViewAction.setText("Show Repositories View");
        gotoTaskRepositoryViewAction.setImageDescriptor(BambooImages.REPOSITORIES);
        gotoRepoViewACI.fill(this.menu, -1);
    }

    public Menu getMenu(Menu parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        this.addActions();
        return this.menu;
    }
}

