/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.internal.bestpractices.springiderules;

import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.validation.AbstractXmlValidationRule;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.beans.core.model.validation.IXmlValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TooManyBeansInFileRule
extends AbstractXmlValidationRule
implements IValidationRule<IBeansModelElement, IBeansValidationContext> {
    public static final String INFO_MESSAGE = "There are too many beans defined in this file. Consider decomposing into multiple bean configuration files.";
    public static final String ERROR_ID = "tooManyBeandInFile";
    private static final int DEFAULT_MAX_BEAN_COUNT = 40;
    private int maxBeanCount = 40;

    public void setMaxBeanCount(int maxBeanCount) {
        this.maxBeanCount = maxBeanCount;
    }

    protected boolean supports(Node node) {
        return node instanceof Document;
    }

    protected void validate(Node node, IXmlValidationContext context) {
        NodeList beansNodeList = ((Document)node).getElementsByTagName("beans");
        if (beansNodeList.getLength() < 1) {
            return;
        }
        Element beansElement = (Element)beansNodeList.item(0);
        NodeList beanNodeList = beansElement.getElementsByTagName("bean");
        if (beanNodeList.getLength() > this.maxBeanCount) {
            context.info(node, ERROR_ID, INFO_MESSAGE, new ValidationProblemAttribute[0]);
        }
    }
}

