/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.internal.bestpractices.quickfix;

import org.eclipse.core.resources.IMarker;
import org.springframework.ide.eclipse.internal.bestpractices.quickfix.AbstractCreateMethodMarkerResolution;

public class CreateNewPropertyMarkerResolution
extends AbstractCreateMethodMarkerResolution {
    private String missingProperty = this.extractQuotedString("property '", this.getMarkerMessage());
    private String targetClass = this.extractQuotedString("class '", this.getMarkerMessage());

    public CreateNewPropertyMarkerResolution(IMarker marker) {
        super(marker);
    }

    @Override
    public String getDescription() {
        return "Create property '" + this.missingProperty + "' in class '" + this.targetClass + "'";
    }

    @Override
    public String getLabel() {
        return "Create property '" + this.missingProperty + "' in class '" + this.targetClass + "'";
    }

    @Override
    protected String getNewMethodName() {
        return this.propertyToSetterName(this.missingProperty);
    }

    @Override
    protected String getNewMethodParameters() {
        return "object";
    }

    @Override
    protected String getTargetClass() {
        return this.targetClass;
    }

    private String propertyToSetterName(String propertyName) {
        String firstChar = propertyName.substring(0, 1);
        String setterName = "set" + firstChar.toUpperCase() + propertyName.substring(1);
        return setterName;
    }
}

