/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableTo;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.graph.actions.EditPropertiesAction;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.EditPropertiesCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelDecorator;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelProvider;

public class StateTransitionSection
extends AbstractPropertySection
implements PropertyChangeListener {
    private Text onText;
    private Text toText;
    private Button browseStateButton;
    private IStateTransition stateTransition;
    private IStateTransition oldStateTransition;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            ActionRegistry actionRegistry = (ActionRegistry)editor.getAdapter(ActionRegistry.class);
            EditPropertiesAction action = (EditPropertiesAction)actionRegistry.getAction((Object)"Edit_propeties");
            action.setOpenDialog(false);
            EditPropertiesCommand command = new EditPropertiesCommand();
            IStateTransition clone = null;
            if (StateTransitionSection.this.stateTransition instanceof ICloneableModelElement) {
                clone = (IStateTransition)((ICloneableModelElement)StateTransitionSection.this.stateTransition).cloneModelElement();
            }
            clone.setOn(StateTransitionSection.this.onText.getText());
            command.setChild((ICloneableModelElement<IWebflowModelElement>)((ICloneableModelElement)StateTransitionSection.this.stateTransition), (IWebflowModelElement)clone);
            if (action != null) {
                StateTransitionSection.this.stateTransition.removePropertyChangeListener((PropertyChangeListener)StateTransitionSection.this);
                action.runWithCommand(command);
                StateTransitionSection.this.stateTransition.addPropertyChangeListener((PropertyChangeListener)StateTransitionSection.this);
            }
        }
    };
    private ModifyListener toStateListener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            ActionRegistry actionRegistry = (ActionRegistry)editor.getAdapter(ActionRegistry.class);
            EditPropertiesAction action = (EditPropertiesAction)actionRegistry.getAction((Object)"Edit_propeties");
            action.setOpenDialog(false);
            EditPropertiesCommand command = new EditPropertiesCommand();
            IState state = WebflowModelXmlUtils.getStateById((IWebflowState)((IWebflowState)StateTransitionSection.this.stateTransition.getElementParent().getElementParent()), (String)StateTransitionSection.this.toText.getText());
            command.setNewTarget((ITransitionableTo)state);
            command.setChild((ICloneableModelElement<IWebflowModelElement>)((ICloneableModelElement)StateTransitionSection.this.stateTransition));
            command.setOnlyReconnect(true);
            if (action != null) {
                StateTransitionSection.this.stateTransition.removePropertyChangeListener((PropertyChangeListener)StateTransitionSection.this);
                action.runWithCommand(command);
                StateTransitionSection.this.stateTransition.addPropertyChangeListener((PropertyChangeListener)StateTransitionSection.this);
            }
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.onText = this.getWidgetFactory().createText(composite, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.onText.setLayoutData((Object)data);
        this.onText.addModifyListener(this.listener);
        CLabel labelLabel = this.getWidgetFactory().createCLabel(composite, "Event id:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.onText, -5);
        data.top = new FormAttachment((Control)this.onText, 0, 0x1000000);
        labelLabel.setLayoutData((Object)data);
        this.browseStateButton = this.getWidgetFactory().createButton(composite, "...", 8);
        data = new FormData();
        data.left = new FormAttachment(96, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)labelLabel, 4);
        this.browseStateButton.setLayoutData((Object)data);
        this.browseStateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StateTransitionSection.this.handleSelectionChanged();
            }
        });
        this.toText = this.getWidgetFactory().createText(composite, "");
        data = new FormData();
        this.toText.setEditable(false);
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(95, 0);
        data.top = new FormAttachment((Control)this.browseStateButton, 0, 0x1000000);
        this.toText.setLayoutData((Object)data);
        this.toText.addModifyListener(this.toStateListener);
        CLabel comboLabel = this.getWidgetFactory().createCLabel(composite, "To State id:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.toText, -5);
        data.top = new FormAttachment((Control)this.browseStateButton, 0, 0x1000000);
        comboLabel.setLayoutData((Object)data);
    }

    protected void handleSelectionChanged() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getPart().getSite().getShell(), (ILabelProvider)new DecoratingLabelProvider((ILabelProvider)new WebflowModelLabelProvider(), (ILabelDecorator)new WebflowModelLabelDecorator()));
        dialog.setBlockOnOpen(true);
        dialog.setElements(WebflowModelXmlUtils.getStates((IWebflowModelElement)((IWebflowModelElement)this.stateTransition.getElementParent()), (boolean)false).toArray());
        dialog.setEmptySelectionMessage("Enter a valid state id");
        dialog.setTitle("State reference");
        dialog.setMessage("Please select a state reference");
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            this.toText.setText(((IState)dialog.getFirstResult()).getId());
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (this.oldStateTransition != null) {
            this.oldStateTransition.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (input instanceof AbstractConnectionEditPart && ((AbstractConnectionEditPart)input).getModel() instanceof IStateTransition) {
            this.stateTransition = (IStateTransition)((AbstractConnectionEditPart)input).getModel();
            this.stateTransition.addPropertyChangeListener((PropertyChangeListener)this);
            this.oldStateTransition = this.stateTransition;
        }
    }

    public void refresh() {
        this.onText.removeModifyListener(this.listener);
        this.toText.removeModifyListener(this.toStateListener);
        if (this.stateTransition.getOn() != null) {
            this.onText.setText(this.stateTransition.getOn());
        }
        if (this.stateTransition.getToState() != null) {
            this.toText.setText(this.stateTransition.getToState().getId());
        }
        this.onText.addModifyListener(this.listener);
        this.toText.addModifyListener(this.toStateListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh();
    }

    public void dispose() {
        if (this.stateTransition != null) {
            this.stateTransition.removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.dispose();
    }
}

