/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.commands;

import org.eclipse.gef.commands.Command;
import org.springframework.ide.eclipse.webflow.core.internal.model.EntryActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExitActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.RenderActions;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IActionState;
import org.springframework.ide.eclipse.webflow.core.model.IEntryActions;
import org.springframework.ide.eclipse.webflow.core.model.IExitActions;
import org.springframework.ide.eclipse.webflow.core.model.IRenderActions;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IViewState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;

public class AddActionCommand
extends Command {
    private IActionElement child;
    private IWebflowModelElement parent;

    public void execute() {
        if (this.child.getType() == IActionElement.ACTION_TYPE.ACTION && this.parent instanceof IActionState) {
            this.child.setElementParent(this.parent);
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.RENDER_ACTION && this.parent instanceof IViewState) {
            IViewState state = (IViewState)this.parent;
            if (state.getRenderActions() == null) {
                RenderActions entry = new RenderActions();
                entry.createNew((IWebflowModelElement)state);
                state.setRenderActions((IRenderActions)entry);
            }
            this.child.setElementParent((IWebflowModelElement)state.getRenderActions());
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.ENTRY_ACTION && this.parent instanceof IState) {
            IState state = (IState)this.parent;
            if (state.getEntryActions() == null) {
                EntryActions entry = new EntryActions();
                entry.createNew((IWebflowModelElement)state);
                state.setEntryActions((IEntryActions)entry);
            }
            this.child.setElementParent((IWebflowModelElement)state.getEntryActions());
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.EXIT_ACTION && this.parent instanceof IState) {
            IState state = (IState)this.parent;
            if (state.getExitActions() == null) {
                ExitActions entry = new ExitActions();
                entry.createNew((IWebflowModelElement)state);
                state.setExitActions((IExitActions)entry);
            }
            this.child.setElementParent((IWebflowModelElement)state.getExitActions());
        }
        if (this.child.getElementParent() instanceof IEntryActions) {
            ((IEntryActions)this.child.getElementParent()).addEntryAction(this.child);
        } else if (this.child.getElementParent() instanceof IExitActions) {
            ((IExitActions)this.child.getElementParent()).addExitAction(this.child);
        } else if (this.child.getElementParent() instanceof IRenderActions) {
            ((IRenderActions)this.child.getElementParent()).addRenderAction(this.child);
        } else if (this.child.getElementParent() instanceof IActionState) {
            ((IActionState)this.child.getElementParent()).addAction(this.child);
        }
    }

    public void setChild(IActionElement newChild) {
        this.child = newChild;
    }

    public void undo() {
        IExitActions state;
        if (this.child.getElementParent() instanceof IEntryActions) {
            ((IEntryActions)this.child.getElementParent()).removeEntryAction(this.child);
        } else if (this.child.getElementParent() instanceof IExitActions) {
            ((IExitActions)this.child.getElementParent()).removeExitAction(this.child);
        } else if (this.child.getElementParent() instanceof IRenderActions) {
            ((IRenderActions)this.child.getElementParent()).removeRenderAction(this.child);
        } else if (this.child.getElementParent() instanceof IActionState) {
            ((IActionState)this.child.getElementParent()).removeAction(this.child);
        }
        if (this.child.getType() == IActionElement.ACTION_TYPE.RENDER_ACTION && this.child.getElementParent() instanceof IRenderActions) {
            IRenderActions state2 = (IRenderActions)this.child.getElementParent();
            if (state2 != null && state2.getRenderActions().size() == 0) {
                ((IViewState)state2.getElementParent()).setRenderActions(null);
            }
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.ENTRY_ACTION && this.child.getElementParent() instanceof IEntryActions) {
            IEntryActions state3 = (IEntryActions)this.child.getElementParent();
            if (state3 != null && state3.getEntryActions().size() == 0) {
                ((IState)state3.getElementParent()).setEntryActions(null);
            }
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.EXIT_ACTION && this.child.getElementParent() instanceof IExitActions && (state = (IExitActions)this.child.getElementParent()) != null && state.getExitActions().size() == 0) {
            ((IState)state.getElementParent()).setExitActions(null);
        }
    }

    public void setParent(IWebflowModelElement element) {
        this.parent = element;
    }
}

