/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.validator;

import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.quickfix.BeansEditorValidator;
import org.springframework.ide.eclipse.quickfix.QuickfixUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeanValidatorVisitor {
    private final IBeansConfig config;
    private final IResourceModelElement contextElement;
    private final IReporter reporter;
    private final BeansEditorValidator editorValidator;

    public BeanValidatorVisitor(IBeansConfig config, IResourceModelElement contextElement, IReporter reporter, BeansEditorValidator editorValidator) {
        this.config = config;
        this.contextElement = contextElement;
        this.reporter = reporter;
        this.editorValidator = editorValidator;
    }

    private boolean visitAttributes(IDOMNode node, boolean reportError) {
        boolean errorFound = false;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return false;
        }
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            if (attribute instanceof AttrImpl) {
                AttrImpl attrImpl = (AttrImpl)attribute;
                errorFound |= QuickfixUtils.validateAttribute(this.config, this.contextElement, attrImpl, node, this.reporter, reportError, this.editorValidator);
            }
            ++i;
        }
        return errorFound;
    }

    private boolean visitChildren(IDOMNode node, boolean reportError) {
        NodeList childNodes = node.getChildNodes();
        boolean errorFound = false;
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode instanceof IDOMNode) {
                this.visitNode((IDOMNode)childNode, true, reportError);
            }
            ++i;
        }
        return errorFound;
    }

    public boolean visitNode(IDOMNode node, boolean visitChildren, boolean reportError) {
        boolean errorFound = this.visitAttributes(node, reportError);
        if (errorFound) {
            return true;
        }
        if (visitChildren) {
            return this.visitChildren(node, reportError);
        }
        return false;
    }
}

