/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.proposals;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.quickfix.proposals.BeanAttributeQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.QuickfixReflectionUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CreateImportQuickFixProposal
extends BeanAttributeQuickFixProposal
implements ICompletionProposal {
    private final IDOMNode beanNode;
    private final IPath relativeImportPath;
    private final IBeansProject project;

    public CreateImportQuickFixProposal(int offset, int length, boolean missingEndQuote, IBean importBean, IDOMNode beanNode, IBeansProject project, IFile file) {
        super(offset, length, missingEndQuote);
        this.beanNode = beanNode;
        this.project = project;
        IResource resource = importBean.getElementResource();
        IPath importPath = resource.getLocation();
        IPath path = file.getParent().getLocation();
        this.relativeImportPath = QuickfixReflectionUtils.getRelativePath(path, importPath);
    }

    @Override
    public void applyQuickFix(IDocument document) {
        IDOMElement beansNode = (IDOMElement)this.beanNode.getOwnerDocument().getDocumentElement();
        NodeList children = beansNode.getChildNodes();
        Node child = children.item(0);
        Element importNode = this.beanNode.getOwnerDocument().createElement(BeansSchemaConstants.ELEM_IMPORT);
        importNode.setAttribute(BeansSchemaConstants.ATTR_RESOURCE, this.getResourcePath());
        beansNode.insertBefore((Node)importNode, child);
        new FormatProcessorXML().formatNode((Node)importNode);
        if (this.project instanceof BeansProject) {
            ((BeansProject)this.project).setImportsEnabled(true);
        }
    }

    public String getDisplayString() {
        return "Import " + this.getResourcePath();
    }

    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.imp_obj.gif");
    }

    private String getResourcePath() {
        return this.relativeImportPath.toString();
    }
}

