/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.springframework.ide.eclipse.quickfix.QuickfixImages;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AnnotationCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.StringLiteralTrackedPosition;

public class PackageNameCompletionProposal
extends AnnotationCompletionProposal {
    private final String packageName;
    private Annotation annotation;
    private ASTNode oldLiteral;
    private IAnnotation iAnnotation;
    private JavaContentAssistInvocationContext javaContext;

    public PackageNameCompletionProposal(String packageName, IAnnotation a, JavaContentAssistInvocationContext javaContext) {
        super(packageName, javaContext.getCompilationUnit(), QuickfixImages.getImage(QuickfixImages.PACKAGE));
        this.packageName = packageName;
        this.iAnnotation = a;
        this.javaContext = javaContext;
    }

    public PackageNameCompletionProposal(String packageName, Annotation annotation, ASTNode oldNode, JavaContentAssistInvocationContext javaContext) {
        super(packageName, javaContext.getCompilationUnit(), QuickfixImages.getImage(QuickfixImages.PACKAGE));
        this.packageName = packageName;
        this.annotation = annotation;
        this.oldLiteral = oldNode;
    }

    private boolean isWithinRange(Expression value, int invocationOffset) {
        int startPosition = value.getStartPosition();
        int length = value.getLength();
        return startPosition < invocationOffset && startPosition + length >= invocationOffset;
    }

    private void setupASTNodes() {
        SingleMemberAnnotation singleMemberAnnotation;
        Expression value;
        ICompilationUnit cu = this.javaContext.getCompilationUnit();
        SourceViewer sourceViewer = (SourceViewer)this.javaContext.getViewer();
        int invocationOffset = this.javaContext.getInvocationOffset();
        AssistContext assistContext = new AssistContext(cu, (ISourceViewer)sourceViewer, invocationOffset, 0);
        ASTNode node = ((SourceRefElement)this.iAnnotation).findNode(assistContext.getASTRoot());
        this.annotation = (Annotation)node;
        if (node instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)node;
            List pairs = normalAnnotation.values();
            for (MemberValuePair pair : pairs) {
                Expression value2 = pair.getValue();
                if (value2 instanceof StringLiteral) {
                    if (!this.isWithinRange(value2, invocationOffset)) continue;
                    this.oldLiteral = value2;
                    continue;
                }
                if (!(value2 instanceof ArrayInitializer)) continue;
                ArrayInitializer arrayInit = (ArrayInitializer)value2;
                List expressions = arrayInit.expressions();
                for (Expression expression : expressions) {
                    if (!(expression instanceof StringLiteral) || !this.isWithinRange(expression, invocationOffset)) continue;
                    this.oldLiteral = expression;
                }
            }
        } else if (node instanceof SingleMemberAnnotation && this.isWithinRange(value = (singleMemberAnnotation = (SingleMemberAnnotation)node).getValue(), invocationOffset)) {
            this.oldLiteral = value;
        }
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        this.setupASTNodes();
        AST ast = this.annotation.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (this.oldLiteral == null) {
            return rewrite;
        }
        StringLiteral newValue = ast.newStringLiteral();
        newValue.setLiteralValue(this.packageName);
        ITrackedNodePosition newValuePosition = rewrite.track((ASTNode)newValue);
        rewrite.replace(this.oldLiteral, (ASTNode)newValue, null);
        this.setTrackPosition(new StringLiteralTrackedPosition(newValuePosition, newValuePosition.getStartPosition() + 1 + this.packageName.length(), 0, true));
        return rewrite;
    }
}

