/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.processors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.processors.AbstractAnnotationQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AddRequestMappingParamCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class RequestMappingParamAnnotationQuickAssistProcessor
extends AbstractAnnotationQuickAssistProcessor {
    private List<SingleVariableDeclaration> params;
    private static final Class<?>[] PARAM_ANNOTATION_CLASSES = new Class[]{PathVariable.class, RequestBody.class, RequestParam.class, ModelAttribute.class};

    @Override
    public String getAnnotationName() {
        return "RequestParam";
    }

    @Override
    public boolean isQuickfixAvailable(FieldDeclaration fieldDecl, IInvocationContext context) {
        return false;
    }

    @Override
    public boolean isQuickfixAvailable(MethodDeclaration methodDecl, IInvocationContext context) {
        return false;
    }

    @Override
    public boolean isQuickfixAvailable(SingleVariableDeclaration param, IInvocationContext context) {
        if (ProposalCalculatorUtil.hasAnnotation("RequestMapping", param.getParent())) {
            Class<?>[] classArray = PARAM_ANNOTATION_CLASSES;
            int n = PARAM_ANNOTATION_CLASSES.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> annotationClass = classArray[n2];
                if (ProposalCalculatorUtil.hasAnnotation(annotationClass.getSimpleName(), (ASTNode)param)) {
                    return false;
                }
                ++n2;
            }
            ITypeBinding typeBinding = param.getType().resolveBinding();
            return !ProposalCalculatorUtil.isKnownRequestMappingParamType(context.getCompilationUnit().getJavaProject().getProject(), typeBinding);
        }
        return false;
    }

    @Override
    public boolean isQuickfixAvailable(TypeDeclaration typeDecl, IInvocationContext context) {
        return false;
    }

    @Override
    protected void setUpFields() {
        this.params = new ArrayList<SingleVariableDeclaration>();
    }

    @Override
    public List<IJavaCompletionProposal> getAssistsForMethod(MethodDeclaration methodDecl, SimpleName name, ICompilationUnit cu) {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        for (SingleVariableDeclaration param : this.params) {
            proposals.addAll(this.getAssistsForMethodParam(param, name, cu));
        }
        return proposals;
    }

    @Override
    public List<IJavaCompletionProposal> getAssistsForMethodParam(SingleVariableDeclaration param, SimpleName name, ICompilationUnit cu) {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        Class<?>[] classArray = PARAM_ANNOTATION_CLASSES;
        int n = PARAM_ANNOTATION_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> annotationClass = classArray[n2];
            proposals.add((IJavaCompletionProposal)new AddRequestMappingParamCompletionProposal(param, annotationClass, cu));
            ++n2;
        }
        return proposals;
    }
}

