/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.springframework.ide.eclipse.quickfix.jdt.processors.PathVariableAnnotationQuickAssistProcessor;

public class PathVariableQuickFixProcessor
implements IQuickFixProcessor {
    private static final Collection<IJavaCompletionProposal> EMPTY_RESULT = new ArrayList<IJavaCompletionProposal>(0);

    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        return 0x4000000 == problemId;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ArrayList<IJavaCompletionProposal> collectedCorrections = new ArrayList<IJavaCompletionProposal>();
        if (locations != null && locations.length > 0) {
            int i = 0;
            while (i < locations.length) {
                collectedCorrections.addAll(this.getCorrections(context, locations[i]));
                ++i;
            }
        }
        return collectedCorrections.toArray(new IJavaCompletionProposal[collectedCorrections.size()]);
    }

    private Collection<IJavaCompletionProposal> getCorrections(IInvocationContext context, IProblemLocation location) {
        if ("com.springsource.sts.jdt.quickfix.marker".equals(location.getMarkerType())) {
            AssistContext assistContext = new AssistContext(context.getCompilationUnit(), null, location.getOffset(), location.getLength());
            ASTNode node = assistContext.getCoveringNode();
            return new PathVariableAnnotationQuickAssistProcessor().getAssists(node, (IInvocationContext)assistContext);
        }
        return EMPTY_RESULT;
    }
}

