/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.launch.BootLaunchConfigurationDelegate;
import org.springframework.ide.eclipse.boot.launch.properties.PropertyNameContentProposalProvider;
import org.springframework.ide.eclipse.boot.launch.util.ILaunchConfigurationTabSection;
import org.springframework.ide.eclipse.boot.launch.util.TextCellEditorWithContentProposal;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesProposalProcessor;
import org.springframework.ide.eclipse.boot.util.StringUtil;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;

public class PropertiesTableSection
extends WizardPageSection
implements ILaunchConfigurationTabSection {
    private static final String[] COLUMN_NAMES = new String[]{"property", "value"};
    private static final int PROPERTY_NAME_COLUMN = 0;
    private static final KeyStroke CTRL_SPACE = KeyStroke.getInstance((int)262144, (int)32);
    private final LiveExpression<IProject> project;
    private LiveVariable<Boolean> dirtyState = new LiveVariable((Object)false);
    private CheckboxTableViewer tableViewer;
    private List<BootLaunchConfigurationDelegate.PropVal> props = new ArrayList<BootLaunchConfigurationDelegate.PropVal>();
    private CheckStateSynchronizer checkStateProvider = new CheckStateSynchronizer();
    private BootLaunchConfigurationDelegate.PropVal lastMouseDownTarget;
    private MouseListener clickListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            BootLaunchConfigurationDelegate.PropVal clickedElement = this.getElementUnder(e);
            PropertiesTableSection.this.lastMouseDownTarget = clickedElement;
            if (e.button == 1 && clickedElement == null) {
                PropertiesTableSection.this.lastMouseDownTarget = null;
                PropertiesTableSection.this.addNewRow(true);
            }
        }

        private BootLaunchConfigurationDelegate.PropVal getElementUnder(MouseEvent e) {
            ViewerCell cell = PropertiesTableSection.this.tableViewer.getCell(new Point(((PropertiesTableSection)PropertiesTableSection.this).tableViewer.getTable().getBounds().width / 2, e.y));
            if (cell != null) {
                return (BootLaunchConfigurationDelegate.PropVal)cell.getElement();
            }
            return null;
        }
    };

    @Override
    public LiveVariable<Boolean> getDirtyState() {
        return this.dirtyState;
    }

    public PropertiesTableSection(IPageWithSections owner, LiveExpression<IProject> project) {
        super(owner);
        this.project = project;
    }

    public void createContents(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Override properties:");
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)0);
        this.tableViewer.setColumnProperties(COLUMN_NAMES);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setCheckStateProvider((ICheckStateProvider)this.checkStateProvider);
        this.tableViewer.addCheckStateListener((ICheckStateListener)this.checkStateProvider);
        this.tableViewer.getTable().addMouseListener(this.clickListener);
        this.createColumns();
        this.createContextMenu();
        this.tableViewer.setInput(this.props);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tableViewer.getTable());
    }

    private void createContextMenu() {
        Table table = this.tableViewer.getTable();
        Menu contextMenu = new Menu((Control)table);
        this.addMenu(contextMenu, "Delete Row", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BootLaunchConfigurationDelegate.PropVal toRemove = PropertiesTableSection.this.lastMouseDownTarget;
                if (toRemove != null) {
                    PropertiesTableSection.this.props.remove(toRemove);
                    PropertiesTableSection.this.tableViewer.remove((Object)toRemove);
                    PropertiesTableSection.this.dirtyState.setValue((Object)true);
                }
            }
        });
        this.addMenu(contextMenu, "Add Row", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesTableSection.this.addNewRow(false);
            }
        });
        table.setMenu(contextMenu);
    }

    private void addNewRow(boolean reuseExistingEmptyRow) {
        BootLaunchConfigurationDelegate.PropVal newProp = null;
        if (reuseExistingEmptyRow) {
            newProp = this.findEmptyProp();
        }
        if (newProp == null) {
            newProp = new BootLaunchConfigurationDelegate.PropVal("", "", true);
            this.props.add(newProp);
            this.tableViewer.add((Object)newProp);
        }
        this.tableViewer.editElement((Object)newProp, 0);
    }

    private BootLaunchConfigurationDelegate.PropVal findEmptyProp() {
        if (!this.props.isEmpty()) {
            BootLaunchConfigurationDelegate.PropVal last = this.props.get(this.props.size() - 1);
            if (!StringUtil.hasText((String)last.name)) {
                return last;
            }
        }
        return null;
    }

    private void addMenu(Menu contextMenu, String label, SelectionAdapter handler) {
        MenuItem mnu = new MenuItem(contextMenu, 8);
        mnu.setText(label);
        mnu.addSelectionListener((SelectionListener)handler);
    }

    private String getColumnValue(Object element, int col) {
        if (element instanceof BootLaunchConfigurationDelegate.PropVal) {
            if (col == 0) {
                return ((BootLaunchConfigurationDelegate.PropVal)element).name;
            }
            return ((BootLaunchConfigurationDelegate.PropVal)element).value;
        }
        return null;
    }

    private void setColumnValue(Object element, int col, Object value) {
        if (element instanceof BootLaunchConfigurationDelegate.PropVal) {
            if (col == 0) {
                ((BootLaunchConfigurationDelegate.PropVal)element).name = (String)value;
            } else {
                ((BootLaunchConfigurationDelegate.PropVal)element).value = (String)value;
            }
            this.dirtyState.setValue((Object)true);
        }
    }

    private void createColumns() {
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            final int _i = i;
            String colname = COLUMN_NAMES[i];
            TableViewerColumn col = new TableViewerColumn((TableViewer)this.tableViewer, 0);
            col.getColumn().setWidth(200);
            col.getColumn().setText(colname);
            col.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    Object element = cell.getElement();
                    cell.setText(PropertiesTableSection.this.getColumnValue(element, _i));
                }
            });
            col.setEditingSupport((EditingSupport)new CellEditorSupport(i));
            ++i;
        }
    }

    @Override
    public void initializeFrom(ILaunchConfiguration conf) {
        try {
            this.props = BootLaunchConfigurationDelegate.getProperties(conf);
            this.dirtyState.setValue((Object)false);
            if (this.tableViewer != null) {
                this.tableViewer.setInput(this.props);
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy conf) {
        BootLaunchConfigurationDelegate.setProperties(conf, this.props);
        this.dirtyState.setValue((Object)false);
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy conf) {
        BootLaunchConfigurationDelegate.clearProperties(conf);
    }

    public class CellEditorSupport
    extends EditingSupport {
        private CellEditor editor;
        private int col;

        public CellEditorSupport(int col) {
            super((ColumnViewer)PropertiesTableSection.this.tableViewer);
            this.col = col;
            if (col == 0) {
                PropertyNameContentProposalProvider proposalProvider = new PropertyNameContentProposalProvider((LiveExpression<IProject>)PropertiesTableSection.this.project);
                this.editor = new TextCellEditorWithContentProposal((Composite)PropertiesTableSection.this.tableViewer.getTable(), proposalProvider, CTRL_SPACE, SpringPropertiesProposalProcessor.AUTO_ACTIVATION_CHARS).setProposalAcceptanceStyle(2);
            } else {
                this.editor = new TextCellEditor((Composite)PropertiesTableSection.this.tableViewer.getTable());
            }
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            String val = PropertiesTableSection.this.getColumnValue(element, this.col);
            return val != null;
        }

        protected Object getValue(Object element) {
            return PropertiesTableSection.this.getColumnValue(element, this.col);
        }

        protected void setValue(Object element, Object value) {
            PropertiesTableSection.this.setColumnValue(element, this.col, value);
            PropertiesTableSection.this.tableViewer.refresh(element);
        }
    }

    private class CheckStateSynchronizer
    implements ICheckStateProvider,
    ICheckStateListener {
        private CheckStateSynchronizer() {
        }

        public boolean isGrayed(Object element) {
            return false;
        }

        public boolean isChecked(Object element) {
            if (element instanceof BootLaunchConfigurationDelegate.PropVal) {
                BootLaunchConfigurationDelegate.PropVal prop = (BootLaunchConfigurationDelegate.PropVal)element;
                return prop.isChecked;
            }
            return false;
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            BootLaunchConfigurationDelegate.PropVal element = (BootLaunchConfigurationDelegate.PropVal)event.getElement();
            element.isChecked = event.getChecked();
            PropertiesTableSection.this.dirtyState.setValue((Object)true);
        }
    }
}

