/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.profiles;

import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.launch.IProfileHistory;
import org.springframework.ide.eclipse.boot.util.StringUtil;
import org.springsource.ide.eclipse.commons.frameworks.core.util.ArrayEncoder;

public class ProfileHistory
implements IProfileHistory {
    private static final String PROFILE_HISTORY = "spring.boot.launch.profile.history";
    private static final String[] NO_PROFILES = new String[0];
    private int maxProfileHistory = 10;

    public ProfileHistory setMaxHistory(int max) {
        Assert.isLegal((max >= 0 ? 1 : 0) != 0);
        this.maxProfileHistory = max;
        return this;
    }

    @Override
    public String[] getHistory(IProject project) {
        String[] storedHistory;
        IEclipsePreferences prefs;
        if (project != null && (prefs = this.getPreferences(project)) != null && (storedHistory = ArrayEncoder.decode((String)prefs.get(PROFILE_HISTORY, null))) != null) {
            return storedHistory;
        }
        return NO_PROFILES;
    }

    protected void setHistory(IProject project, String[] profiles) {
        try {
            IEclipsePreferences prefs = this.getPreferences(project);
            if (prefs != null) {
                prefs.put(PROFILE_HISTORY, ArrayEncoder.encode((String[])profiles));
                prefs.flush();
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
    }

    public void updateHistory(IProject project, String profile) {
        if (project != null && StringUtil.hasText((String)profile)) {
            LinkedList<String> history = new LinkedList<String>(Arrays.asList(this.getHistory(project)));
            history.remove(profile);
            history.addFirst(profile);
            while (history.size() > this.maxProfileHistory) {
                history.removeLast();
            }
            this.setHistory(project, history.toArray(new String[history.size()]));
        }
    }

    protected IEclipsePreferences getPreferences(IProject p) {
        ProjectScope scope = new ProjectScope(p);
        IEclipsePreferences prefs = scope.getNode("org.springframework.ide.eclipse.boot");
        return prefs;
    }
}

