/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.ui;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.springsource.ide.eclipse.commons.core.preferences.GlobalPreferenceEnhancer;

public class PreferencesCurator
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREF_DIALOG_ID = "org.springsource.ide.eclipse.commons.curatorPreferencesPage";

    public PreferencesCurator() {
        super("Global Preferences Curator");
    }

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
        this.setDescription("Sets/unsets a bunch of preferences that makes Eclipse more awesome");
    }

    protected Control createContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout(1, true));
        Label desc = new Label(contents, 64);
        desc.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        desc.setText("We have scoured the Eclipse preferences pages and determined a handful of preferences\nthat are not set in an optimal way.  Do you trust us?");
        Composite allComposite = new Composite(contents, 2048);
        allComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        allComposite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(allComposite, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText("Set/Reset all curated preferences.");
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        Button allSetButton = new Button(allComposite, 8);
        allSetButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        allSetButton.setText("Set all preferences");
        allSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new GlobalPreferenceEnhancer().enhanceAllPreferences();
            }
        });
        Button allUnsetButton = new Button(allComposite, 8);
        allUnsetButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        allUnsetButton.setText("Reset all preferences");
        allUnsetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new GlobalPreferenceEnhancer().undoAll();
            }
        });
        Composite jdtComposite = new Composite(contents, 2048);
        jdtComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        jdtComposite.setLayout((Layout)new GridLayout(1, false));
        Label jdtLabel = new Label(jdtComposite, 0);
        jdtLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        jdtLabel.setText("JDT preferences");
        jdtLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        Label jdtLabelExplanation = new Label(jdtComposite, 0);
        jdtLabelExplanation.setLayoutData((Object)new GridData(1, 16384, false, false));
        jdtLabelExplanation.setText("We set the following JDT preferences:\n* Editor smart paste (true)\n* Editor smart semicolon placement (true)\n* Editor smart opening brace placement (true)\n* Editor smart backspace (true)\n* Editor smart tab (true)\n* Escape text when pasting into a string literal (true)\n* Auto activation delay (40 ms)\n");
        Button jdtSetButton = new Button(jdtComposite, 8);
        jdtSetButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        jdtSetButton.setText("Set JDT preferences only");
        jdtSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new GlobalPreferenceEnhancer().enhanceJDTPreferences();
            }
        });
        Button jdtUnsetButton = new Button(jdtComposite, 8);
        jdtUnsetButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        jdtUnsetButton.setText("Reset JDT preferences only");
        jdtUnsetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new GlobalPreferenceEnhancer().undoJDTEnhance();
            }
        });
        PreferenceLinkArea jdtEditorArea = new PreferenceLinkArea(jdtComposite, 64, "org.eclipse.jdt.ui.preferences.SmartTypingPreferencePage", "Go to the <a>JDT smart typing preferences page</a>", (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridData data = new GridData(4, 0x1000000, false, false);
        jdtEditorArea.getControl().setLayoutData((Object)data);
        PreferenceLinkArea jdtContentAssistArea = new PreferenceLinkArea(jdtComposite, 64, "org.eclipse.jdt.ui.preferences.CodeAssistPreferencePage", "Go to the <a>JDT content assist preferences page</a>", (IWorkbenchPreferenceContainer)this.getContainer(), null);
        data = new GridData(4, 0x1000000, false, false);
        jdtContentAssistArea.getControl().setLayoutData((Object)data);
        Composite m2eComposite = new Composite(contents, 2048);
        m2eComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        m2eComposite.setLayout((Layout)new GridLayout(1, false));
        Label m2eLabel = new Label(m2eComposite, 0);
        m2eLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        m2eLabel.setText("M2E preferences");
        m2eLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        Label m2eLabelExplanation = new Label(m2eComposite, 0);
        m2eLabelExplanation.setLayoutData((Object)new GridData(1, 16384, false, false));
        m2eLabelExplanation.setText("We set the following M2E preferences:\n* Hide folders of physically nested projects (true)\n* Download repository updates on startup (false)\n* Open XML page in pom editor by default (true)");
        Button m2eSetButton = new Button(m2eComposite, 8);
        m2eSetButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        m2eSetButton.setText("Set M2E preferences only");
        m2eSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new GlobalPreferenceEnhancer().enhanceM2EPreferences();
            }
        });
        Button m2eUnsetButton = new Button(m2eComposite, 8);
        m2eUnsetButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        m2eUnsetButton.setText("Reset M2E preferences only");
        m2eUnsetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new GlobalPreferenceEnhancer().undoJDTEnhance();
            }
        });
        PreferenceLinkArea m2eArea = new PreferenceLinkArea(m2eComposite, 64, "org.eclipse.m2e.core.preferences.Maven2PreferencePage", "Go to the <a>M2E preferences page</a>", (IWorkbenchPreferenceContainer)this.getContainer(), null);
        data = new GridData(4, 0x1000000, false, false);
        m2eArea.getControl().setLayoutData((Object)data);
        PreferenceLinkArea m2eUIArea = new PreferenceLinkArea(m2eComposite, 64, "org.eclipse.m2e.core.ui.preferences.UserInterfacePreferencePage", "Go to the <a>M2E UI preferences page</a>", (IWorkbenchPreferenceContainer)this.getContainer(), null);
        data = new GridData(4, 0x1000000, false, false);
        m2eUIArea.getControl().setLayoutData((Object)data);
        if (Platform.getBundle((String)"org.eclipse.m2e.core") == null) {
            m2eComposite.setEnabled(false);
            m2eLabel.setText(String.valueOf(m2eLabel.getText()) + " (not installed)");
            m2eSetButton.setEnabled(false);
            m2eUnsetButton.setEnabled(false);
            m2eUIArea.getControl().setEnabled(false);
            m2eArea.getControl().setEnabled(false);
        }
        return contents;
    }
}

