/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.editor;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.dadacoalition.yedit.Activator;
import org.dadacoalition.yedit.YEditLog;
import org.dadacoalition.yedit.editor.SymfonyCompatibilityMode;
import org.dadacoalition.yedit.editor.YAMLOutlineElement;
import org.dadacoalition.yedit.editor.YEdit;
import org.dadacoalition.yedit.editor.YEditStyledLabelProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Node;

public class YAMLContentOutlinePage
extends ContentOutlinePage {
    private Object input;
    private IDocumentProvider documentProvider;
    private YEdit yamlEditor;
    public static final String YAMLSEGMENT = "_____YAML_Element";

    public YAMLContentOutlinePage(IDocumentProvider provider, YEdit editor) {
        this.documentProvider = provider;
        this.yamlEditor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        int expandLevels = -1;
        if (!prefs.getBoolean("autoExpandOutline")) {
            expandLevels = 0;
        }
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new ContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new YEditStyledLabelProvider(this.yamlEditor.getColorManager()));
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        viewer.setAutoExpandLevel(expandLevels);
        if (this.input != null) {
            this.setInput(this.input);
        }
    }

    public void setInput(Object input) {
        this.input = input;
        this.update();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        YEditLog.logger.info("Select in the outline view changed");
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.yamlEditor.resetHighlightRange();
        } else {
            YAMLOutlineElement segment = (YAMLOutlineElement)((IStructuredSelection)selection).getFirstElement();
            int start = segment.position.getOffset();
            int length = segment.position.getLength();
            try {
                this.yamlEditor.setHighlightRange(start, length, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.yamlEditor.resetHighlightRange();
            }
        }
    }

    public void update() {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            viewer.setInput(this.input);
        }
    }

    public void toggleCollapse() {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer.getVisibleExpandedElements().length == 0) {
            viewer.expandAll();
        } else {
            viewer.collapseAll();
        }
    }

    protected class ContentProvider
    implements ITreeContentProvider {
        protected Yaml yamlParser = new Yaml();
        protected List<YAMLOutlineElement> yamlDocuments = new ArrayList<YAMLOutlineElement>();
        protected IPositionUpdater positionUpdater = new DefaultPositionUpdater("_____YAML_Element");

        protected ContentProvider() {
        }

        public void parse(IDocument document) {
            String content = document.get();
            IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
            if (prefs.getBoolean("symfonyCompatibilityMode")) {
                SymfonyCompatibilityMode sr = new SymfonyCompatibilityMode(((YAMLContentOutlinePage)YAMLContentOutlinePage.this).yamlEditor.sourceViewerConfig.getScanner());
                content = sr.fixScalars(document);
            }
            this.yamlDocuments.clear();
            try {
                for (Node rootNode : this.yamlParser.composeAll((Reader)new StringReader(content))) {
                    YAMLOutlineElement ye = new YAMLOutlineElement(rootNode, document);
                    this.yamlDocuments.add(ye);
                }
            }
            catch (YAMLException yAMLException) {
                YEditLog.logger.info("Syntax error found during parsing for outlinew view. Parsing stopped.");
            }
        }

        public Object[] getChildren(Object element) {
            if (element instanceof YAMLOutlineElement) {
                return ((YAMLOutlineElement)element).children.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof YAMLOutlineElement) {
                return ((YAMLOutlineElement)element).parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof YAMLOutlineElement) {
                return ((YAMLOutlineElement)element).children.size() != 0;
            }
            return false;
        }

        public Object[] getElements(Object arg0) {
            if (this.yamlDocuments != null) {
                return this.yamlDocuments.toArray();
            }
            return null;
        }

        public void dispose() {
            if (this.yamlDocuments != null) {
                this.yamlDocuments.clear();
                this.yamlDocuments = null;
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            IDocument document;
            YEditLog.logger.fine("Input to the Outline view was changed.");
            if (oldInput != null && (document = YAMLContentOutlinePage.this.documentProvider.getDocument(oldInput)) != null) {
                try {
                    document.removePositionCategory(YAMLContentOutlinePage.YAMLSEGMENT);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                document.removePositionUpdater(this.positionUpdater);
            }
            if (newInput != null && (document = YAMLContentOutlinePage.this.documentProvider.getDocument(newInput)) != null) {
                document.addPositionCategory(YAMLContentOutlinePage.YAMLSEGMENT);
                document.addPositionUpdater(this.positionUpdater);
                this.parse(document);
            }
        }
    }
}

