/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.compiler.IProblem;

class CompilationProblemRequestor
implements IProblemRequestor {
    private boolean fIsActive = false;
    private boolean fIsRunning = false;
    private List<IProblem> fCollectedProblems;

    CompilationProblemRequestor() {
    }

    public void beginReporting() {
        this.fIsRunning = true;
        this.fCollectedProblems = new ArrayList<IProblem>();
    }

    public void acceptProblem(IProblem problem) {
        if (this.isActive()) {
            this.fCollectedProblems.add(problem);
        }
    }

    public void endReporting() {
        this.fIsRunning = false;
    }

    public boolean isActive() {
        return this.fIsActive && this.fCollectedProblems != null;
    }

    public void setIsActive(boolean isActive) {
        if (this.fIsActive != isActive) {
            this.fIsActive = isActive;
            if (this.fIsActive) {
                this.startCollectingProblems();
            } else {
                this.stopCollectingProblems();
            }
        }
    }

    private void startCollectingProblems() {
        this.fCollectedProblems = new ArrayList<IProblem>();
    }

    private void stopCollectingProblems() {
    }

    public List getCollectedProblems() {
        return this.fCollectedProblems;
    }

    public boolean isRunning() {
        return this.fIsRunning;
    }
}

