/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hyperlink.bean;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.JavaElementHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConstructorArgNameHyperlinkCalculator
implements IHyperlinkCalculator {
    @Override
    public IHyperlink createHyperlink(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        String parentName = null;
        if (parentNode != null) {
            parentName = parentNode.getNodeName();
        }
        ArrayList<String> propertyPaths = new ArrayList<String>();
        hyperlinkRegion = BeansEditorUtils.extractPropertyPathFromCursorPosition(hyperlinkRegion, cursor, target, propertyPaths);
        if ("bean".equals(parentName) && StringUtils.hasText((String)target)) {
            IBeansConfig config;
            IType type;
            IFile file = BeansEditorUtils.getFile(document);
            String className = BeansEditorUtils.getClassNameForBean(file, node.getOwnerDocument(), parentNode);
            if (file != null && file.exists() && (type = JdtUtils.getJavaType((IProject)file.getProject(), (String)className)) != null && (config = BeansCorePlugin.getModel().getConfig(file)) != null && parentNode instanceof Element) {
                IBean bean;
                int count;
                IModelElement element = BeansModelUtils.getModelElement((Element)((Element)parentNode), (IModelElement)config);
                int argIndex = this.getArgumentIndex(node);
                if (argIndex >= 0 && element instanceof IBean && (count = (bean = (IBean)element).getConstructorArguments().size()) > 0) {
                    try {
                        Set methods = Introspector.getConstructors((IType)type, (int)count, (boolean)false);
                        for (IMethod candidate : methods) {
                            if (!target.equalsIgnoreCase(candidate.getParameterNames()[argIndex])) continue;
                            return new JavaElementHyperlink(hyperlinkRegion, (IJavaElement)candidate);
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
        }
        return null;
    }

    private int getArgumentIndex(Node arg) {
        if (arg instanceof Element && "constructor-arg".equals(arg.getNodeName())) {
            Element parent = (Element)arg.getParentNode();
            NodeList list = parent.getElementsByTagName("constructor-arg");
            int i = 0;
            while (i < list.getLength()) {
                Node candidate = list.item(i);
                if (arg.equals(candidate)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }
}

