/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hyperlink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.springframework.ide.eclipse.beans.core.namespaces.ToolAnnotationUtils;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IAnnotationBasedHyperlinkDetector;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IMultiHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ToolAnnotationBasedHyperlinkCalculator
implements IMultiHyperlinkCalculator {
    @Override
    public IHyperlink[] createHyperlinks(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        ArrayList<IHyperlink> hyperlinks = new ArrayList<IHyperlink>();
        this.detectAnnotationBasedHyperlinks(textViewer, hyperlinkRegion, true, hyperlinks, node);
        return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }

    @Override
    public IHyperlink createHyperlink(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        IHyperlink[] hyperlinks = this.createHyperlinks(name, target, node, parentNode, document, textViewer, hyperlinkRegion, cursor);
        if (hyperlinks.length > 0) {
            return hyperlinks[0];
        }
        return null;
    }

    private void detectAnnotationBasedHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks, List<IHyperlink> hyperlinks, Node currentNode) {
        if (currentNode != null && region != null) {
            Attr currentAttr = BeansEditorUtils.getAttrByOffset(currentNode, region.getOffset());
            IDOMAttr attr = (IDOMAttr)currentAttr;
            if (currentAttr != null && region.getOffset() >= attr.getValueRegionStartOffset()) {
                List appInfo = ToolAnnotationUtils.getApplicationInformationElements((Node)currentNode, (String)attr.getLocalName());
                for (Element elem : appInfo) {
                    NodeList children = elem.getChildNodes();
                    int j = 0;
                    while (j < children.getLength()) {
                        Node child = children.item(j);
                        if (child.getNodeType() == 1) {
                            this.invokeAnnotationBasedHyperlinkDetector(textViewer, region, canShowMultipleHyperlinks, hyperlinks, child);
                        }
                        ++j;
                    }
                }
            }
        }
    }

    private void invokeAnnotationBasedHyperlinkDetector(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks, List<IHyperlink> hyperlinks, Node child) {
        IAnnotationBasedHyperlinkDetector[] detectors;
        IAnnotationBasedHyperlinkDetector[] iAnnotationBasedHyperlinkDetectorArray = detectors = NamespaceUtils.getAnnotationBasedHyperlinkDetector(child.getNamespaceURI());
        int n = detectors.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBasedHyperlinkDetector detector = iAnnotationBasedHyperlinkDetectorArray[n2];
            IHyperlink[] detectedHyperlinks = detector.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks, child);
            if (detectedHyperlinks != null) {
                hyperlinks.addAll(Arrays.asList(detectedHyperlinks));
            }
            ++n2;
        }
    }
}

