/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.ui;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.livexp.Activator;
import org.springsource.ide.eclipse.commons.livexp.core.CompositeValidator;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.CommentSection;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithOkButton;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.OkButtonHandler;
import org.springsource.ide.eclipse.commons.livexp.ui.PageSection;
import org.springsource.ide.eclipse.commons.livexp.ui.ValidatorSection;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;

public abstract class DialogWithSections
extends TitleAreaDialog
implements ValueListener<ValidationResult>,
IPageWithSections,
IPageWithOkButton {
    private String title;
    private final OkButtonHandler model;
    private static final long MESSAGE_DELAY = 250L;
    private List<WizardPageSection> sections = null;
    private CompositeValidator validator;
    private UIJob updateJob;

    public DialogWithSections(String title, OkButtonHandler model, Shell shell) {
        super(shell);
        this.title = title;
        this.model = model;
    }

    public void create() {
        super.create();
        this.setTitle(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite page = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 12;
        layout.marginWidth = 12;
        page.setLayout((Layout)layout);
        this.validator = new CompositeValidator();
        for (PageSection pageSection : this.getSections()) {
            pageSection.createContents(page);
            this.validator.addChild((LiveExpression)pageSection.getValidator());
        }
        this.validator.addListener(this);
        DialogWithSections.applyDialogFont((Control)page);
        return page;
    }

    protected synchronized List<WizardPageSection> getSections() {
        if (this.sections == null) {
            this.sections = this.safeCreateSections();
        }
        return this.sections;
    }

    private List<WizardPageSection> safeCreateSections() {
        try {
            return this.createSections();
        }
        catch (CoreException e) {
            Activator.log(e);
            return Arrays.asList(new CommentSection(this, "Dialog couldn't be created because of an unexpected error:+\n" + ExceptionUtil.getMessage((Throwable)e) + "\n\n" + "Check the error log for details"), new ValidatorSection(Validator.alwaysError(ExceptionUtil.getMessage((Throwable)e)), this));
        }
    }

    protected List<WizardPageSection> createSections() throws CoreException {
        return Arrays.asList(new CommentSection(this, "Override DialogWithSections.createSections() to provide real content."), new ValidatorSection(Validator.alwaysError("Subclass must implement validation logic"), this));
    }

    private IStatus toStatus(ValidationResult value) {
        if (value == null || value.isOk()) {
            return Status.OK_STATUS;
        }
        return new Status(value.status, "Activator", value.msg);
    }

    @Override
    public void gotValue(LiveExpression<ValidationResult> exp, ValidationResult status) {
        this.scheduleUpdateJob();
    }

    private synchronized void scheduleUpdateJob() {
        Shell shell = this.getShell();
        if (shell != null) {
            if (this.updateJob == null) {
                this.updateJob = new UIJob("Update Wizard message"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        DialogWithSections.this.updateStatus((ValidationResult)DialogWithSections.this.validator.getValue());
                        return Status.OK_STATUS;
                    }
                };
                this.updateJob.setSystem(true);
            }
            this.updateJob.schedule(250L);
        }
    }

    private void updateStatus(ValidationResult status) {
        boolean enableOk = true;
        if (status == null || status.isOk()) {
            this.setMessage("", 0);
        } else {
            this.setMessage(status.msg, status.getMessageProviderStatus());
            enableOk = status.status < 4;
        }
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(enableOk);
        }
    }

    public void dispose() {
        for (WizardPageSection s : this.sections) {
            s.dispose();
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected final void okPressed() {
        super.okPressed();
        try {
            this.model.performOk();
        }
        catch (Exception e) {
            Activator.log(e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)ExceptionUtil.getMessage((Throwable)e));
        }
    }

    @Override
    public boolean clickOk() {
        Button button = this.getButton(0);
        if (button != null && button.isEnabled()) {
            this.okPressed();
            return true;
        }
        return false;
    }

    @Override
    public IRunnableContext getRunnableContext() {
        return PlatformUI.getWorkbench().getProgressService();
    }
}

