/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.plugin.UISettings;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileToMarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.MarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class PriorityFilter
extends ViewerFilter {
    private List<Integer> priorityList = UISettings.getPriorityIntValues();

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean select = false;
        if (element instanceof PackageRecord) {
            select = this.hasMarkersToShow((PackageRecord)element);
        } else if (element instanceof FileRecord) {
            select = this.hasMarkersToShow((FileRecord)element);
        } else if (element instanceof IMarker) {
            try {
                IMarker marker = (IMarker)element;
                Integer markerPrio = (Integer)marker.getAttribute("pmd_priority");
                select = this.isPriorityEnabled(markerPrio);
            }
            catch (CoreException ce) {
                PMDPlugin.getDefault().logError("message.error.core_exception" + ((Object)((Object)this)).toString(), ce);
            }
        } else if (element instanceof MarkerRecord) {
            MarkerRecord markerRec = (MarkerRecord)element;
            for (Integer priority : this.priorityList) {
                if (markerRec.getPriority() != priority.intValue()) continue;
                select = true;
                break;
            }
        } else if (element instanceof FileToMarkerRecord) {
            select = true;
        }
        return select;
    }

    private boolean isPriorityEnabled(Integer markerPrio) {
        boolean isEnabled = false;
        if (markerPrio != null) {
            for (Integer priority : this.priorityList) {
                if (!markerPrio.equals(priority)) continue;
                isEnabled = true;
                break;
            }
        }
        return isEnabled;
    }

    private boolean hasMarkersToShow(AbstractPMDRecord record) {
        boolean hasMarkers = false;
        for (Integer priority : this.priorityList) {
            IMarker[] markers = record.findMarkersByAttribute("pmd_priority", priority);
            if (markers.length <= 0) continue;
            hasMarkers = true;
            break;
        }
        return hasMarkers;
    }

    public void setPriorityFilterList(List<Integer> newList) {
        this.priorityList = newList;
    }

    public List<Integer> getPriorityFilterList() {
        return this.priorityList;
    }

    public void addPriorityToList(Integer priority) {
        this.priorityList.add(priority);
    }

    public void removePriorityFromList(Integer priority) {
        this.priorityList.remove(priority);
    }

    public void setPriorityFilterListFromString(String newList, String splitter) {
        if (newList != null) {
            String[] newArray = newList.split(splitter);
            ArrayList<Integer> priorities = new ArrayList<Integer>(newArray.length);
            String[] stringArray = newArray;
            int n = newArray.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                priorities.add(Integer.valueOf(element));
                ++n2;
            }
            this.priorityList = priorities;
        }
    }

    public String getPriorityFilterListAsString(String splitter) {
        if (this.priorityList.isEmpty()) {
            return "";
        }
        StringBuilder listString = new StringBuilder(this.priorityList.get(0));
        int i = 1;
        while (i < this.priorityList.size()) {
            listString.append(splitter).append(this.priorityList.get(i));
            ++i;
        }
        return listString.toString();
    }
}

