/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import net.sourceforge.pmd.eclipse.ui.model.ProjectRecord;
import net.sourceforge.pmd.eclipse.ui.model.RootRecord;
import net.sourceforge.pmd.eclipse.ui.views.ChangeRecord;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;

public class ChangeEvaluator {
    private final RootRecord root;

    public ChangeEvaluator(RootRecord theRoot) {
        this.root = theRoot;
    }

    public ChangeRecord<AbstractPMDRecord> changeRecordFor(IResourceChangeEvent event) {
        List<IMarkerDelta> markerDeltas = MarkerUtil.markerDeltasIn(event);
        ArrayList<IResource> changedFiles = new ArrayList<IResource>();
        ArrayList<IProject> changedProjects = new ArrayList<IProject>();
        for (IMarkerDelta markerDelta : markerDeltas) {
            IResource resource = markerDelta.getResource();
            IProject project = resource.getProject();
            if (!changedFiles.contains(resource)) {
                changedFiles.add(resource);
            }
            if (changedProjects.contains(project)) continue;
            changedProjects.add(project);
        }
        ChangeRecord<AbstractPMDRecord> changeRec = new ChangeRecord<AbstractPMDRecord>();
        for (IProject project : changedProjects) {
            List<AbstractPMDRecord>[] array;
            ProjectRecord projectRec = (ProjectRecord)this.root.findResource((IResource)project);
            if (!project.isOpen() || !project.isAccessible()) {
                array = this.updateFiles(project, changedFiles);
                changeRec.removed(array[1]);
                this.root.removeResource((IResource)project);
            } else if (projectRec == null) {
                projectRec = (ProjectRecord)this.root.addResource((IResource)project);
            }
            array = this.updateFiles(project, changedFiles);
            changeRec.added(array[0]);
            changeRec.removed(array[1]);
            changeRec.changed(array[2]);
        }
        return changeRec;
    }

    private List<AbstractPMDRecord>[] updateFiles(IProject project, List<IResource> changedFiles) {
        ArrayList additions = new ArrayList();
        ArrayList<AbstractPMDRecord> removals = new ArrayList<AbstractPMDRecord>();
        ArrayList changes = new ArrayList();
        List[] updatedFiles = new List[]{additions, removals, changes};
        ProjectRecord projectRec = (ProjectRecord)this.root.findResource((IResource)project);
        if (projectRec != null && project.isAccessible()) {
            updatedFiles = ChangeEvaluator.searchProjectForModifications(projectRec, changedFiles);
        } else if (projectRec != null) {
            List<AbstractPMDRecord> packages = projectRec.getChildrenAsList();
            removals.addAll(packages);
            int k = 0;
            while (k < packages.size()) {
                PackageRecord packageRec = (PackageRecord)packages.get(k);
                removals.addAll(packageRec.getChildrenAsList());
                ++k;
            }
            updatedFiles = new List[]{additions, removals, changes};
        }
        return updatedFiles;
    }

    private static List<AbstractPMDRecord>[] searchProjectForModifications(ProjectRecord projectRec, List<IResource> changedFiles) {
        ArrayList<AbstractPMDRecord> additions = new ArrayList<AbstractPMDRecord>();
        ArrayList<AbstractPMDRecord> removals = new ArrayList<AbstractPMDRecord>();
        ArrayList<AbstractPMDRecord> changes = new ArrayList<AbstractPMDRecord>();
        IProject project = (IProject)projectRec.getResource();
        for (IResource resource : changedFiles) {
            AbstractPMDRecord fileRec;
            if (!project.equals((Object)resource.getProject())) continue;
            AbstractPMDRecord rec = projectRec.findResource(resource);
            if (rec != null && rec.getResourceType() == 1) {
                fileRec = (FileRecord)rec;
                ((FileRecord)fileRec).updateChildren();
                if (((FileRecord)fileRec).getResource().isAccessible() && ((FileRecord)fileRec).hasMarkers()) {
                    changes.add(fileRec);
                    continue;
                }
                projectRec.removeResource(((FileRecord)fileRec).getResource());
                removals.add(fileRec);
                PackageRecord packageRec = (PackageRecord)((FileRecord)fileRec).getParent();
                if (packageRec.hasMarkers()) continue;
                projectRec.removeResource(((FileRecord)fileRec).getParent().getResource());
                removals.add(packageRec);
                continue;
            }
            if (rec != null) continue;
            fileRec = projectRec.addResource(resource);
            additions.add(fileRec);
        }
        return new List[]{additions, removals, changes};
    }
}

