/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.priority;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.plugin.UISettings;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferencesManager;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptor;

public class PriorityDescriptorCache {
    private Map<RulePriority, PriorityDescriptor> uiDescriptorsByPriority = new HashMap<RulePriority, PriorityDescriptor>(5);
    public static final PriorityDescriptorCache instance = new PriorityDescriptorCache();

    private PriorityDescriptorCache() {
        this.loadFromPreferences();
    }

    private IPreferencesManager preferencesManager() {
        return PMDPlugin.getDefault().getPreferencesManager();
    }

    public void dumpTo(PrintStream out) {
        for (Map.Entry<RulePriority, PriorityDescriptor> entry : this.uiDescriptorsByPriority.entrySet()) {
            out.println(entry.getKey() + " : " + entry.getValue());
        }
    }

    public void loadFromPreferences() {
        IPreferences preferences = this.preferencesManager().loadPreferences();
        RulePriority[] rulePriorityArray = UISettings.currentPriorities(true);
        int n = rulePriorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            RulePriority rp = rulePriorityArray[n2];
            this.uiDescriptorsByPriority.put(rp, preferences.getPriorityDescriptor(rp).clone());
            ++n2;
        }
    }

    public void storeInPreferences() {
        IPreferencesManager mgr = this.preferencesManager();
        IPreferences prefs = mgr.loadPreferences();
        for (Map.Entry<RulePriority, PriorityDescriptor> entry : this.uiDescriptorsByPriority.entrySet()) {
            prefs.setPriorityDescriptor(entry.getKey(), entry.getValue());
        }
        mgr.storePreferences(prefs);
    }

    public PriorityDescriptor descriptorFor(RulePriority priority) {
        return this.uiDescriptorsByPriority.get(priority);
    }

    public boolean hasChanges() {
        IPreferences preferences = this.preferencesManager().reloadPreferences();
        RulePriority[] rulePriorityArray = UISettings.currentPriorities(true);
        int n = rulePriorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            PriorityDescriptor currentOne;
            RulePriority rp = rulePriorityArray[n2];
            PriorityDescriptor newOne = this.uiDescriptorsByPriority.get(rp);
            if (!newOne.equals(currentOne = preferences.getPriorityDescriptor(rp))) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

