/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.eclipse.ui.editors.SyntaxManager;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ImplementationType;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleSelection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.EnumerationEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.SWTUtil;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.AbstractRulePanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.EditorUsageMode;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.lang.rule.properties.EnumeratedProperty;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class XPathPanelManager
extends AbstractRulePanelManager {
    private StyledText xpathField;
    private Combo xpathVersionField;
    private Label versionLabel;
    private List<String> unknownVariableNames;
    public static final String ID = "xpath";

    public XPathPanelManager(String theTitle, EditorUsageMode theMode, ValueChangeListener theListener) {
        super(ID, theTitle, theMode, theListener);
    }

    @Override
    protected boolean canManageMultipleRules() {
        return false;
    }

    @Override
    protected boolean canWorkWith(Rule rule) {
        return RuleSelection.implementationType(rule) == ImplementationType.XPath;
    }

    @Override
    protected List<String> fieldErrors() {
        ArrayList<String> errors = new ArrayList<String>(2);
        if (StringUtil.isEmpty((String)this.xpathField.getText())) {
            errors.add("Missing XPATH code");
        }
        if (this.unknownVariableNames == null || this.unknownVariableNames.isEmpty()) {
            return errors;
        }
        errors.add("Unknown variables: " + this.unknownVariableNames);
        return errors;
    }

    @Override
    protected void clearControls() {
        this.xpathField.setText("");
    }

    @Override
    public void showControls(boolean flag) {
        this.xpathField.setVisible(flag);
        this.xpathVersionField.setVisible(flag);
        this.versionLabel.setVisible(flag);
    }

    @Override
    protected void updateOverridenFields() {
        Rule rule = this.soleRule();
        if (rule instanceof RuleReference) {
            RuleReference ruleReference = (RuleReference)rule;
            this.xpathField.setBackground((Color)(ruleReference.hasOverriddenProperty((PropertyDescriptor)XPathRule.XPATH_DESCRIPTOR) ? overridenColour : null));
        }
    }

    @Override
    public Control setupOn(Composite parent) {
        GridData gridData = new GridData(768);
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        panel.setLayout((Layout)layout);
        this.xpathField = this.newCodeField(panel);
        SyntaxManager.adapt(this.xpathField, ID, null);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.xpathField.setLayoutData((Object)gridData);
        this.xpathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (!XPathPanelManager.this.isActive()) {
                    return;
                }
                Rule soleRule = XPathPanelManager.this.soleRule();
                if (soleRule == null) {
                    return;
                }
                String newValue = XPathPanelManager.this.xpathField.getText().trim();
                String existingValue = ((String)soleRule.getProperty((PropertyDescriptor)XPathRule.XPATH_DESCRIPTOR)).trim();
                if (StringUtil.areSemanticEquals((String)existingValue, (String)newValue)) {
                    return;
                }
                XPathPanelManager.this.validate();
                soleRule.setProperty((PropertyDescriptor)XPathRule.XPATH_DESCRIPTOR, (Object)newValue);
                XPathPanelManager.this.valueChanged((PropertyDescriptor<?>)XPathRule.XPATH_DESCRIPTOR, newValue);
            }
        });
        this.versionLabel = new Label(panel, 0);
        this.versionLabel.setText(SWTUtil.stringFor("preference.ruleedit.label.xpath.version"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = false;
        this.versionLabel.setLayoutData((Object)gridData);
        final EnumeratedProperty ep = XPathRule.VERSION_DESCRIPTOR;
        this.xpathVersionField = new Combo(panel, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = false;
        this.xpathVersionField.setLayoutData((Object)gridData);
        this.xpathVersionField.setItems(SWTUtil.labelsIn(ep.choices(), 0));
        this.xpathVersionField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rule rule = XPathPanelManager.this.soleRule();
                int selectionIdx = XPathPanelManager.this.xpathVersionField.getSelectionIndex();
                Object newValue = ep.choices()[selectionIdx][1];
                if (newValue.equals(rule.getProperty((PropertyDescriptor)ep))) {
                    return;
                }
                rule.setProperty((PropertyDescriptor)ep, newValue);
            }
        });
        return panel;
    }

    private void configureVersionFieldFor(Rule rule) {
        Object value = rule.getProperty((PropertyDescriptor)XPathRule.VERSION_DESCRIPTOR);
        int selectionIdx = EnumerationEditorFactory.indexOf(value, XPathRule.VERSION_DESCRIPTOR.choices());
        if (selectionIdx >= 0) {
            this.xpathVersionField.select(selectionIdx);
        }
    }

    @Override
    public void adapt() {
        Rule soleRule = this.soleRule();
        if (soleRule == null) {
            this.shutdown(this.xpathField);
        } else {
            this.show(this.xpathField, ((String)soleRule.getProperty((PropertyDescriptor)XPathRule.XPATH_DESCRIPTOR)).trim());
            this.configureVersionFieldFor(soleRule);
        }
        this.validate();
    }
}

