/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.core.impl;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.core.IRuleSetManager;

public class RuleSetManagerImpl
implements IRuleSetManager {
    private final Set<RuleSet> ruleSets = new HashSet<RuleSet>();
    private final Set<RuleSet> defaultRuleSets = new HashSet<RuleSet>();

    @Override
    public Set<RuleSet> getRegisteredRuleSets() {
        return this.ruleSets;
    }

    @Override
    public void registerRuleSet(RuleSet ruleSet) {
        this.checkForNull(ruleSet);
        this.ruleSets.add(ruleSet);
    }

    @Override
    public void unregisterRuleSet(RuleSet ruleSet) {
        this.checkForNull(ruleSet);
        this.ruleSets.remove(ruleSet);
    }

    @Override
    public Set<RuleSet> getDefaultRuleSets() {
        return this.defaultRuleSets;
    }

    @Override
    public void registerDefaultRuleSet(RuleSet ruleSet) {
        this.checkForNull(ruleSet);
        this.defaultRuleSets.add(ruleSet);
    }

    @Override
    public void unregisterDefaultRuleSet(RuleSet ruleSet) {
        this.checkForNull(ruleSet);
        this.defaultRuleSets.remove(ruleSet);
    }

    private void checkForNull(RuleSet ruleSet) {
        if (ruleSet == null) {
            throw new IllegalArgumentException("ruleSet cannot be null");
        }
    }
}

