/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules;

import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.Mapping;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.WebflowValidationContext;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules.WebflowValidationRuleUtils;
import org.springframework.util.StringUtils;

public class MappingValidationRule
implements IValidationRule<Mapping, WebflowValidationContext> {
    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof Mapping && context instanceof WebflowValidationContext;
    }

    public void validate(Mapping mapping, WebflowValidationContext context, IProgressMonitor monitor) {
        if (!StringUtils.hasText((String)mapping.getSource())) {
            context.error(mapping, "NO_INPUT_ATTRIBUTE_ATTRIBUTE", "Element 'mapping' element requires 'input-attribute' attribute", new ValidationProblemAttribute[0]);
        }
        if (!StringUtils.hasText((String)mapping.getTarget()) && !StringUtils.hasText((String)mapping.getTargetCollection())) {
            context.error(mapping, "INVALID_USAGE_OF_TARGET_ATTRIBUTE", "Using 'target' and 'target-collection' attributes is not allowed on 'mapping' element", new ValidationProblemAttribute[0]);
        }
        if (StringUtils.hasText((String)mapping.getTo()) && WebflowValidationRuleUtils.getJavaType(mapping.getTo(), context) == null) {
            context.error(mapping, "NO_CLASS_FOUND", MessageUtils.format((String)"Class 'to' \"{0}\" cannot be resolved", (Object)mapping.getTo()), new ValidationProblemAttribute[0]);
        }
        if (StringUtils.hasText((String)mapping.getFrom()) && WebflowValidationRuleUtils.getJavaType(mapping.getFrom(), context) == null) {
            context.error(mapping, "NO_CLASS_FOUND", MessageUtils.format((String)"Class 'from' \"{0}\" cannot be resolved", (Object)mapping.getFrom()), new ValidationProblemAttribute[0]);
        }
    }
}

