/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules;

import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.AttributeMapper;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.WebflowValidationContext;
import org.springframework.util.StringUtils;

public class AttributeMapperValidationRule
implements IValidationRule<AttributeMapper, WebflowValidationContext> {
    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof AttributeMapper && context instanceof WebflowValidationContext;
    }

    public void validate(AttributeMapper state, WebflowValidationContext context, IProgressMonitor monitor) {
        if (StringUtils.hasText((String)state.getBean()) && !WebflowModelUtils.isReferencedBeanFound(context.getWebflowConfig(), state.getBean())) {
            context.error(state, "INVALID_BEAN_REFERENCE", MessageUtils.format((String)"Referenced bean \"{0}\" cannot be found", (Object)state.getBean()), new ValidationProblemAttribute[0]);
        }
    }
}

