/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractModelElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.ITransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableTo;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;

public abstract class Transition
extends AbstractModelElement
implements ITransition {
    protected IWebflowState webflowState;
    protected ITransitionableTo targetState;
    protected ITransitionableFrom sourceState;

    public Transition(IWebflowState webflowState) {
        this.webflowState = webflowState;
    }

    @Override
    public ITransitionableTo getToState() {
        if (this.targetState == null) {
            this.targetState = (ITransitionableTo)WebflowModelXmlUtils.getStateById(this.webflowState, this.getToStateId());
        }
        return this.targetState;
    }

    @Override
    public void setToState(ITransitionableTo state) {
        Object newTargetState = null;
        if (state != null) {
            newTargetState = (ITransitionableTo)WebflowModelXmlUtils.getStateById(this.webflowState, state.getId());
        }
        if (newTargetState != null && !newTargetState.equals(this.targetState)) {
            if (this.targetState != null) {
                this.targetState.removeInputTransition(this);
            }
            this.setAttribute("to", state.getId());
            super.fireStructureChange("outputs", state);
            this.targetState = newTargetState;
            if (this.targetState != null) {
                this.targetState.addInputTransition(this);
            }
        } else {
            if (state != null) {
                this.setAttribute("to", state.getId());
            } else {
                this.targetState = newTargetState;
            }
            super.fireStructureChange("outputs", state);
        }
    }

    @Override
    public String getToStateId() {
        return this.getAttribute("to");
    }
}

