/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractModelElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.Argument;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IArgument;
import org.springframework.ide.eclipse.webflow.core.model.IAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IMethodArguments;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MethodArguments
extends AbstractModelElement
implements IMethodArguments {
    private List<IArgument> arguments;

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        super.init(node, parent);
        this.arguments = new ArrayList<IArgument>();
        NodeList children = node.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                IDOMNode child = (IDOMNode)children.item(i);
                if ("argument".equals(child.getLocalName())) {
                    Argument arg = new Argument();
                    arg.init(child, this);
                    this.arguments.add(arg);
                }
                ++i;
            }
        }
    }

    @Override
    public void addArgument(IArgument arg) {
        if (!this.arguments.contains(arg)) {
            this.arguments.add(arg);
            WebflowModelXmlUtils.insertNode((Node)arg.getNode(), (Node)this.getNode());
            super.firePropertyChange("add_children", new Integer(this.arguments.indexOf(arg)), arg);
        }
    }

    @Override
    public List<IArgument> getArguments() {
        return this.arguments;
    }

    @Override
    public void removeArgument(IArgument arg) {
        if (this.arguments.contains(arg)) {
            this.arguments.remove(arg);
            this.getNode().removeChild((Node)arg.getNode());
            super.fireStructureChange("remove_children", arg);
        }
    }

    @Override
    public void createNew(IWebflowModelElement parent) {
        IDOMNode node = (IDOMNode)parent.getNode().getOwnerDocument().createElement("method-arguments");
        this.init(node, parent);
    }

    @Override
    public void removeAll() {
        for (IArgument action : this.arguments) {
            this.getNode().removeChild((Node)action.getNode());
        }
        this.arguments = new ArrayList<IArgument>();
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IAttribute iAttribute : this.getAttributes()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iAttribute.accept(visitor, monitor);
            }
            for (IArgument iArgument : this.getArguments()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iArgument.accept(visitor, monitor);
            }
        }
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IWebflowModelElement> children = new ArrayList<IWebflowModelElement>();
        children.addAll(this.getAttributes());
        children.addAll(this.getArguments());
        return children.toArray(new IModelElement[children.size()]);
    }
}

