/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template.infrastructure.processor;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.springframework.ide.eclipse.wizard.template.ErrorUtils;
import org.springframework.ide.eclipse.wizard.template.infrastructure.processor.ProcessingInfo;
import org.springframework.ide.eclipse.wizard.template.infrastructure.processor.TemplateProcessor;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.FileSystemUtils;
import org.springsource.ide.eclipse.commons.core.Policy;
import org.springsource.ide.eclipse.commons.core.ZipFileUtil;
import org.springsource.ide.eclipse.commons.ui.UiStatusHandler;

public class TemplateProjectCreator {
    private final Shell shell;
    private volatile IProject project;
    private final URL archiveFile;
    private final ProcessingInfo processingInfo;
    private final TemplateProcessor templateProcessor;
    private final TemplateProcessor fileNameProcessor;
    private final URI projectPath;

    public TemplateProjectCreator(IProject project, URI projectPath, URL archiveFile, Shell shell, TemplateProcessor templateProcessor, TemplateProcessor fileNameProcessor, ProcessingInfo processingInfo) {
        this.project = project;
        this.projectPath = projectPath;
        this.archiveFile = archiveFile;
        this.shell = shell;
        this.templateProcessor = templateProcessor;
        this.fileNameProcessor = fileNameProcessor;
        this.processingInfo = processingInfo;
    }

    /*
     * Unable to fully structure code
     */
    public IProject createProject(IProgressMonitor monitor) throws CoreException {
        projectName = this.project.getName();
        unzipFolder = this.unzipProject(monitor);
        op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                monitor.subTask("Creating project " + projectName);
                Policy.checkCancelled((IProgressMonitor)monitor);
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProjectDescription projectDescription = workspace.newProjectDescription(projectName);
                URI projectLocation = TemplateProjectCreator.this.projectPath != null && !ResourcesPlugin.getWorkspace().getRoot().getLocationURI().equals(TemplateProjectCreator.this.projectPath) ? TemplateProjectCreator.this.projectPath : null;
                projectDescription.setLocationURI(projectLocation);
                TemplateProjectCreator.this.project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                TemplateProjectCreator.this.project.open((IProgressMonitor)new SubProgressMonitor(monitor, 20));
                monitor.subTask("Importing project " + projectName);
                Policy.checkCancelled((IProgressMonitor)monitor);
                try {
                    TemplateProjectCreator.this.importFiles(TemplateProjectCreator.this.project, unzipFolder.listFiles()[0], (IProgressMonitor)new SubProgressMonitor(monitor, 70));
                }
                catch (IOException e) {
                    Status status = new Status(4, "org.springframework.ide.eclipse.wizard", "Unable to create template project", (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
        };
        try {
            monitor.beginTask("Importing project", 100);
            workspace = ResourcesPlugin.getWorkspace();
            this.project = workspace.getRoot().getProject(projectName);
            if (!this.project.exists()) ** GOTO lbl15
            result = new boolean[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = MessageDialog.openQuestion((Shell)TemplateProjectCreator.this.shell, (String)"Create Template Project", (String)("A project named " + TemplateProjectCreator.this.project.getName() + " already exists in the workspace. Overwrite the existing project?"));
                }
            });
            if (!result[0]) {
                return null;
            }
            try {
                this.project.delete(true, true, monitor);
lbl15:
                // 2 sources

                op.run(monitor);
                monitor.done();
            }
            catch (InterruptedException v0) {
                throw new OperationCanceledException();
            }
            catch (InvocationTargetException e) {
                errorMessage = ErrorUtils.getErrorMessage(e);
                status = new Status(4, "org.springframework.ide.eclipse.wizard", "Error during template project creation" + (errorMessage != null ? " due to: " + errorMessage : ""), (Throwable)e);
                UiStatusHandler.logAndDisplay((IStatus)status);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            if (unzipFolder != null) {
                this.deleteFile(unzipFolder);
            }
            monitor.done();
        }
        return this.project;
    }

    private void deleteFile(File file) {
        if (file.isDirectory()) {
            File[] children;
            File[] fileArray = children = file.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.deleteFile(child);
                ++n2;
            }
        }
        file.delete();
    }

    private File getMappedFile(File source, File destination, String sourceBasePath, String destinationBasePath) {
        String path;
        String mappedPath;
        if (source.isDirectory() && (mappedPath = this.fileNameProcessor.replacePathForDirectory(path = source.getPath(), File.separatorChar)) != null) {
            mappedPath = String.valueOf(destinationBasePath) + mappedPath.substring(sourceBasePath.length());
            return new File(mappedPath);
        }
        String contentName = source.getName();
        String mappedContentName = this.fileNameProcessor.replaceTokens(contentName);
        return new File(destination, mappedContentName);
    }

    private void importFiles(IProject project, File unzipFolder, IProgressMonitor monitor) throws IOException, InvocationTargetException, InterruptedException {
        FileSystemStructureProvider provider = FileSystemStructureProvider.INSTANCE;
        ImportOperation operation = new ImportOperation(project.getFullPath(), (Object)unzipFolder, (IImportStructureProvider)provider, new IOverwriteQuery(){

            public String queryOverwrite(String pathString) {
                return "YES";
            }
        });
        operation.setContext(this.shell);
        operation.setOverwriteResources(true);
        operation.setCreateContainerStructure(false);
        operation.run(monitor);
    }

    private void processDirectory(File source, File destination, String sourceBasePath, String destinationBasePath) throws IOException {
        File[] fileArray = source.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File content = fileArray[n2];
            File subFileOrDir = this.getMappedFile(content, destination, sourceBasePath, destinationBasePath);
            if (!this.shouldExclude(subFileOrDir)) {
                if (content.isDirectory()) {
                    subFileOrDir.mkdirs();
                    this.processDirectory(content, subFileOrDir, sourceBasePath, destinationBasePath);
                } else {
                    this.templateProcessor.process(content, subFileOrDir);
                }
            }
            ++n2;
        }
    }

    private boolean shouldExclude(File file) {
        AntPathMatcher pathMatcher = new AntPathMatcher();
        for (String exclusionPattern : this.processingInfo.getExclusionPatterns()) {
            if (!pathMatcher.match(exclusionPattern, file.getAbsolutePath().replace('\\', '/'))) continue;
            return true;
        }
        return false;
    }

    private File unzipProject(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Unzip project", 10);
        File unzipFolder = null;
        try {
            File tempFile = File.createTempFile("tempFile", null);
            String parentPath = tempFile.getParent();
            tempFile.delete();
            unzipFolder = new File(String.valueOf(parentPath) + "/unzipFolder");
            if (unzipFolder.exists()) {
                this.deleteFile(unzipFolder);
            }
            unzipFolder.mkdir();
            if (this.archiveFile.getProtocol().equals("file") && !new File(this.archiveFile.toURI()).isDirectory()) {
                ZipFileUtil.unzip((URL)this.archiveFile, (File)unzipFolder, (IProgressMonitor)monitor);
            } else {
                File templateDir = new File(unzipFolder, "template");
                FileSystemUtils.copyRecursively((File)new File(this.archiveFile.toURI()), (File)templateDir);
                File templateXml = new File(templateDir, "template.xml");
                File wizardJson = new File(templateDir, "wizard.json");
                templateXml.delete();
                wizardJson.delete();
            }
            File tempFolder = new File(String.valueOf(parentPath) + "/tempFolder");
            if (tempFolder.exists()) {
                this.deleteFile(tempFolder);
            }
            tempFolder.mkdir();
            this.processDirectory(unzipFolder, tempFolder, unzipFolder.getPath(), tempFolder.getPath());
            this.deleteFile(unzipFolder);
            monitor.done();
            return tempFolder;
        }
        catch (IOException e) {
            String message = NLS.bind((String)"Could not create template project {0} because {1}", (Object)this.project, (Object)e.getLocalizedMessage());
            final Status status = new Status(4, "org.springframework.ide.eclipse.wizard", message, (Throwable)e);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    UiStatusHandler.logAndDisplay((IStatus)status);
                }
            });
            throw new CoreException((IStatus)status);
        }
        catch (URISyntaxException e) {
            String message = NLS.bind((String)"The project path {0} in template.xml does not exist or can't be read: {1}.", (Object)this.project, (Object)e.getLocalizedMessage());
            final Status status = new Status(4, "org.springframework.ide.eclipse.wizard", message, (Throwable)e);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    UiStatusHandler.logAndDisplay((IStatus)status);
                }
            });
            throw new CoreException((IStatus)status);
        }
    }
}

