/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template.infrastructure;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ITemplateProjectData;
import org.springframework.ide.eclipse.wizard.template.infrastructure.RuntimeTemplateProjectZipCreatorVisitor;
import org.springsource.ide.eclipse.commons.content.core.util.ContentUtil;
import org.springsource.ide.eclipse.commons.content.core.util.Descriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RuntimeTemplateProjectData
implements ITemplateProjectData {
    private final IProject project;
    private Descriptor descriptor;
    private File zippedProject;
    private File jsonDescriptor;

    public RuntimeTemplateProjectData(IProject project) throws CoreException {
        this.project = project;
        this.initialize();
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    private void initialize() throws CoreException {
        IFile descriptorFile = this.project.getFile("template.xml");
        DocumentBuilder documentBuilder = ContentUtil.createDocumentBuilder();
        try {
            Document document = documentBuilder.parse(descriptorFile.getContents());
            Element rootNode = document.getDocumentElement();
            if (rootNode == null) {
                throw new SAXException("No root node");
            }
            if (!"template".equals(rootNode.getNodeName())) {
                throw new SAXException("Not a valid template");
            }
            NodeList children = rootNode.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node childNode = children.item(i);
                if (childNode.getNodeType() == 1) {
                    if ("descriptor".equals(childNode.getNodeName())) {
                        this.descriptor = Descriptor.read((Node)childNode);
                    } else if ("json".equals(childNode.getNodeName())) {
                        String filePath = ContentUtil.getAttributeValue((Node)childNode, (String)"path");
                        if (filePath == null) {
                            throw new SAXException("The json descriptor is invalid");
                        }
                        this.jsonDescriptor = new File(this.project.getLocation().toOSString(), filePath);
                    }
                }
                ++i;
            }
            if (this.descriptor != null) {
                this.zippedProject = this.createZippedProject(this.project.getName());
            }
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Could not read initialization data for template \"" + this.project.getName() + "\"", (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Could not read initialization data for template \"" + this.project.getName() + "\"", (Throwable)e));
        }
    }

    @Override
    public File getJsonDescriptor() {
        return this.jsonDescriptor;
    }

    @Override
    public File getZippedProject() {
        return this.zippedProject;
    }

    private File createZippedProject(String projectName) throws IOException, CoreException {
        if (projectName.length() < 3) {
            projectName = String.valueOf(projectName) + "temp";
        }
        File destFile = File.createTempFile(projectName, ".zip");
        FileOutputStream dest = new FileOutputStream(destFile);
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new BufferedOutputStream(dest));
            this.project.accept((IResourceVisitor)new RuntimeTemplateProjectZipCreatorVisitor(out, null), 2, false);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return destFile;
    }
}

