/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.springframework.ide.eclipse.wizard.template.ErrorUtils;
import org.springsource.ide.eclipse.commons.content.core.ContentManager;
import org.springsource.ide.eclipse.commons.content.core.ContentPlugin;

public class DownloadDescriptorJob
implements IRunnableWithProgress {
    public ContentManager getContentManager() {
        return ContentPlugin.getDefault().getManager();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            IStatus result = Status.OK_STATUS;
            if (this.getContentManager().isDirty()) {
                result = this.getContentManager().refresh(monitor, true);
            }
            if (!result.isOK()) {
                String errorMessage = ErrorUtils.getErrorMessage(result);
                throw new InvocationTargetException(new CoreException(this.getStatus(errorMessage, null)));
            }
        }
        catch (OperationCanceledException e) {
            throw new InvocationTargetException(new CoreException(this.getStatus("Download of descriptor files cancelled.", e)));
        }
    }

    protected IStatus getStatus(String message, Throwable t) {
        return new Status(4, "org.springframework.ide.eclipse.wizard", message, t);
    }
}

