/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.monitor.usage;

import com.atlassian.connector.eclipse.internal.branding.ui.RuntimeUtil;
import com.atlassian.connector.eclipse.internal.monitor.usage.Messages;
import com.atlassian.connector.eclipse.internal.monitor.usage.dialogs.PermissionToMonitorDialog;
import com.atlassian.connector.eclipse.monitor.core.MonitorCorePlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class MonitorUiPlugin
extends AbstractUIPlugin {
    private static final long HOUR = 3600000L;
    public static final long DEFAULT_DELAY_BETWEEN_TRANSMITS = 604800000L;
    public static final String MONITOR_LOG_NAME_OLD = "monitor-log.xml";
    public static final String MONITOR_LOG_NAME = "usage-data.xml";
    public static final String ID_PLUGIN = "com.atlassian.connector.eclipse.monitor.ui";
    private static final long FIVE_MINUTES_IN_MS = 300000L;
    private static MonitorUiPlugin plugin;

    public MonitorUiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("com.atlassian.connector.eclipse.monitor.usage.enabled")) {
                    if (MonitorUiPlugin.this.isMonitoringEnabled()) {
                        MonitorCorePlugin.getDefault().startMonitoring();
                    } else {
                        MonitorCorePlugin.getDefault().stopMonitoring();
                    }
                }
            }
        });
        if (this.isMonitoringEnabled()) {
            MonitorCorePlugin.getDefault().startMonitoring();
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    if (MonitorUiPlugin.this.isFirstTime() && !RuntimeUtil.suppressConfigurationWizards()) {
                        MonitorUiPlugin.this.askUserToEnableMonitoring();
                    }
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, MonitorUiPlugin.ID_PLUGIN, Messages.MonitorUiPlugin_failed_to_start, t));
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        if (this.isMonitoringEnabled()) {
            MonitorCorePlugin.getDefault().stopMonitoring();
        }
        super.stop(context);
        plugin = null;
    }

    public static MonitorUiPlugin getDefault() {
        return plugin;
    }

    private void askUserToEnableMonitoring() {
        final IPreferenceStore store = this.getPreferenceStore();
        UIJob informUserJob = new UIJob("Ask User about Usage Data Monitoring"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                store.setValue("com.atlassian.connector.eclipse.monitor.usage.first.time", "false");
                if (!MonitorUiPlugin.this.isMonitoringEnabled() && new PermissionToMonitorDialog(WorkbenchUtil.getShell()).open() == 2) {
                    MonitorUiPlugin.this.setMonitoringEnabled(true);
                }
                return Status.OK_STATUS;
            }
        };
        informUserJob.setPriority(10);
        informUserJob.schedule(300000L);
    }

    public static IPreferenceStore getPrefs() {
        return MonitorUiPlugin.getDefault().getPreferenceStore();
    }

    public boolean isFirstTime() {
        return !this.getPreferenceStore().contains("com.atlassian.connector.eclipse.monitor.usage.first.time") || this.getPreferenceStore().getBoolean("com.atlassian.connector.eclipse.monitor.usage.first.time");
    }

    public boolean isMonitoringEnabled() {
        return this.getPreferenceStore().getBoolean("com.atlassian.connector.eclipse.monitor.usage.enabled");
    }

    public void setMonitoringEnabled(boolean b) {
        this.getPreferenceStore().setValue("com.atlassian.connector.eclipse.monitor.usage.enabled", b);
    }

    public static class UiUsageMonitorStartup
    implements IStartup {
        public void earlyStartup() {
        }
    }
}

