/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.crucible.api.model;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrucibleVersionInfo
implements Serializable,
Comparable<CrucibleVersionInfo> {
    private final String buildDate;
    private final String releaseNumber;
    private Integer major;
    private Integer minor;
    private Integer maintanance;
    private String build;

    public CrucibleVersionInfo(String releaseNumber, String buildDate) {
        this.buildDate = buildDate;
        this.releaseNumber = releaseNumber;
        this.tokenizeVersionAndSetFields(releaseNumber);
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public String getReleaseNumber() {
        return this.releaseNumber;
    }

    public boolean isVersion2OrGreater() {
        return this.major != null && this.major >= 2;
    }

    public boolean isVersion21OrGreater() {
        if (this.major == null || this.minor == null) {
            return false;
        }
        return this.major > 2 || this.major == 2 && this.minor >= 1;
    }

    public boolean isVersion24OrGrater() {
        if (this.major == null || this.minor == null) {
            return false;
        }
        return this.major > 2 || this.major == 2 && this.minor >= 4;
    }

    private void tokenizeVersionAndSetFields(String number) {
        String[] tokens = number.split("[.]");
        this.major = null;
        this.minor = null;
        this.maintanance = null;
        this.build = null;
        try {
            if (tokens.length > 0) {
                this.major = Integer.valueOf(tokens[0]);
                if (tokens.length > 1) {
                    this.minor = Integer.valueOf(tokens[1]);
                    if (tokens.length > 2) {
                        this.maintanance = Integer.valueOf(tokens[2]);
                        if (tokens.length > 3) {
                            this.build = tokens[3];
                        }
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public Integer getMaintanance() {
        return this.maintanance;
    }

    public String getBuild() {
        return this.build;
    }

    private int compareInts(Integer a, Integer b) {
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        if (a == null && b == null) {
            return 0;
        }
        return a.compareTo(b);
    }

    @Override
    public int compareTo(CrucibleVersionInfo o) {
        int r = this.compareInts(this.major, o.major);
        if (r == 0) {
            r = this.compareInts(this.minor, o.minor);
            if (r == 0) {
                return this.compareInts(this.maintanance, o.maintanance);
            }
            return r;
        }
        return r;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.major != null) {
            sb.append(this.major);
            if (this.minor != null) {
                sb.append(".");
                sb.append(this.minor);
                if (this.maintanance != null) {
                    sb.append(".");
                    sb.append(this.maintanance);
                    if (this.build != null) {
                        sb.append(".");
                        sb.append(this.build);
                    }
                }
            }
        }
        return sb.toString();
    }
}

