/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons;

import java.io.IOException;
import org.apache.commons.io.FilenameUtils;

public class VersionedVirtualFile {
    private String revision;
    private String url;
    private String repoUrl;
    private String contentUrl;
    private static final int HASH_NUMBER = 13;

    public VersionedVirtualFile(String path, String revision) {
        this.revision = revision;
        this.url = path;
    }

    public byte[] contentsToByteArray() throws IOException {
        return new byte[0];
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getName() {
        return FilenameUtils.getName((String)this.getUrl());
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public void setRepoUrl(String repoUrl) {
        this.repoUrl = repoUrl;
    }

    public String getAbsoluteUrl() {
        return String.valueOf(this.repoUrl != null ? this.repoUrl : "") + this.url;
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    public void setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionedVirtualFile that = (VersionedVirtualFile)o;
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.revision != null ? !this.revision.equals(that.revision) : that.revision != null);
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 13 * result + (this.revision != null ? this.revision.hashCode() : 0);
        return result;
    }
}

