/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.commons.misc;

import com.atlassian.connector.commons.misc.IntRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntRanges {
    @NotNull
    private final ArrayList<IntRange> ranges;
    private static final Comparator<IntRange> COMPARATOR = new Comparator<IntRange>(){

        @Override
        public int compare(IntRange o1, IntRange o2) {
            return o1.getMin() - o2.getMin();
        }
    };

    public IntRanges(@NotNull List<IntRange> ranges) {
        this.ranges = new ArrayList<IntRange>(ranges);
        if (this.ranges.isEmpty()) {
            throw new IllegalArgumentException("Cannot create ranges object from the empty list");
        }
        Collections.sort(this.ranges, COMPARATOR);
    }

    public IntRanges(IntRange ... ranges) {
        if (ranges.length == 0) {
            throw new IllegalArgumentException("Cannot create ranges object from the empty list");
        }
        this.ranges = new ArrayList<IntRange>(Arrays.asList(ranges));
        Collections.sort(this.ranges, COMPARATOR);
    }

    public int getTotalMin() {
        return this.ranges.get(0).getMin();
    }

    public int getTotalMax() {
        return this.ranges.get(this.ranges.size() - 1).getMax();
    }

    @NotNull
    public List<IntRange> getRanges() {
        return Collections.unmodifiableList(this.ranges);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntRanges intRanges = (IntRanges)o;
        return this.ranges.equals(intRanges.ranges);
    }

    public int hashCode() {
        return this.ranges.hashCode();
    }

    public String toString() {
        return "[" + StringUtils.join(this.ranges, (char)',') + "]";
    }

    public String toNiceString() {
        StringBuilder sb = new StringBuilder();
        Iterator<IntRange> it = this.ranges.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toNiceString());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

