/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.commons.jira.rss;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.connector.commons.jira.JIRAIssue;
import com.atlassian.connector.commons.jira.JIRASessionPartTwo;
import com.atlassian.connector.commons.jira.beans.JIRASavedFilter;
import com.atlassian.connector.commons.jira.beans.JiraFilter;
import com.atlassian.connector.commons.jira.rss.JIRAException;
import com.atlassian.connector.commons.jira.rss.JIRARssClient;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.remoteapi.jira.JiraCaptchaRequiredException;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraRssAutoRenewClient
implements JIRASessionPartTwo {
    private final JIRARssClient rssClient;
    private Date lastUsed;

    public JiraRssAutoRenewClient(JIRARssClient rssClient) {
        this.rssClient = rssClient;
    }

    @Override
    public void login() throws JIRAException, JiraCaptchaRequiredException {
        this.rssClient.login();
    }

    @Override
    public void testConnection() throws RemoteApiException {
        this.rssClient.testConnection();
    }

    @Override
    public boolean isLoggedIn(ConnectionCfg server) {
        return this.rssClient != null && this.rssClient.isLoggedIn(server);
    }

    @Override
    public List<JIRAIssue> getIssues(JiraFilter filter, String sortBy, String sortOrder, int start, int max) throws JIRAException {
        return this.rssClient.getIssues(filter, sortBy, sortOrder, start, max);
    }

    @Override
    public List<JIRAIssue> getIssues(String jql, String sort, String sortOrder, int start, int size) throws JIRAException {
        return this.rssClient.getIssues(jql, sort, sortOrder, start, size);
    }

    @Override
    public List<JIRAIssue> getSavedFilterIssues(JIRASavedFilter filter, String sortBy, String sortOrder, int start, int max) throws JIRAException {
        return this.rssClient.getSavedFilterIssues(filter, sortBy, sortOrder, start, max);
    }

    @Override
    public JIRAIssue getIssue(String issueKey) throws JIRAException {
        return this.rssClient.getIssue(issueKey);
    }

    public Date getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(Date lastUsed) {
        this.lastUsed = lastUsed;
    }
}

