/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.livegraph.actions;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBeansSession;
import org.springsource.ide.eclipse.commons.core.JdtUtils;
import org.springsource.ide.eclipse.commons.ui.SpringUIUtils;

public abstract class AbstractOpenResourceAction
extends BaseSelectionListenerAction {
    protected AbstractOpenResourceAction(String text) {
        super(text);
    }

    protected String cleanClassName(String className) {
        String cleanClassName = className;
        if (className != null) {
            int ix = className.indexOf(36);
            if (ix > 0) {
                cleanClassName = className.substring(0, ix);
            } else {
                ix = className.indexOf(35);
                if (ix > 0) {
                    cleanClassName = className.substring(0, ix);
                }
            }
        }
        return cleanClassName;
    }

    protected String extractClassName(String resourcePath) {
        int index = resourcePath.lastIndexOf("/WEB-INF/classes/");
        int length = "/WEB-INF/classes/".length();
        if (index >= 0) {
            resourcePath = resourcePath.substring(index + length);
        }
        resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf(".class"));
        resourcePath = resourcePath.replaceAll("\\\\|\\/", ".");
        return resourcePath;
    }

    protected String extractResourcePath(String resourceStr) {
        int indexStart = resourceStr.indexOf("[");
        int indexEnd = resourceStr.indexOf("]");
        if (indexStart > -1 && indexEnd > -1 && indexStart < indexEnd) {
            resourceStr = resourceStr.substring(indexStart + 1, indexEnd);
        }
        return resourceStr;
    }

    protected IProject[] findProjects(LiveBeansSession session) {
        String appName;
        HashSet<IProject> projects = new HashSet<IProject>();
        IProject p = session.getProject();
        if (p != null) {
            projects.add(p);
        }
        if ((appName = session.getApplicationName()) != null && !"".equals(appName)) {
            IModule[] modules;
            IModule[] iModuleArray = modules = ServerUtil.getModules((String)"jst.web");
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                IWebModule webModule;
                IModule module = iModuleArray[n2];
                Object obj = module.loadAdapter(IWebModule.class, (IProgressMonitor)new NullProgressMonitor());
                if (obj instanceof IWebModule && appName.equals((webModule = (IWebModule)obj).getContextRoot())) {
                    projects.add(module.getProject());
                }
                ++n2;
            }
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    protected boolean hasTypeInProject(LiveBeansSession session, String className) {
        IProject[] projects;
        IProject[] iProjectArray = projects = this.findProjects(session);
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IType type = JdtUtils.getJavaType((IProject)project, (String)this.cleanClassName(className));
            if (type != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void openInEditor(LiveBeansSession session, String className) {
        IProject[] projects;
        IProject[] iProjectArray = projects = this.findProjects(session);
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IType type = JdtUtils.getJavaType((IProject)project, (String)this.cleanClassName(className));
            if (type != null) {
                SpringUIUtils.openInEditor((IJavaElement)type);
                break;
            }
            ++n2;
        }
    }
}

