/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.wizards;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.testng.eclipse.util.JDTUtil;
import org.testng.eclipse.util.ResourceUtil;
import org.testng.eclipse.util.SWTUtil;
import org.testng.eclipse.util.StringUtils;
import org.testng.eclipse.util.Utils;

public class NewTestNGClassWizardPage
extends WizardPage {
    private Text m_sourceFolderText;
    private Text m_packageNameText;
    private Text m_classNameText;
    private Text m_xmlFilePath;
    private Map<String, Button> m_annotations = new HashMap<String, Button>();
    private List<Utils.JavaElement> m_elements;
    public static final String[] ANNOTATIONS = new String[]{"BeforeMethod", "AfterMethod", "DataProvider", "BeforeClass", "AfterClass", "", "BeforeTest", "AfterTest", "", "BeforeSuite", "AfterSuite", ""};

    public NewTestNGClassWizardPage() {
        super(ResourceUtil.getString("NewTestNGClassWizardPage.title"));
        this.setTitle(ResourceUtil.getString("NewTestNGClassWizardPage.title"));
        this.setDescription(ResourceUtil.getString("NewTestNGClassWizardPage.description"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        this.createTop(container);
        this.createBottom(container);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void createTop(Composite parent) {
        final Composite container = SWTUtil.createGridContainer(parent, 3);
        this.m_sourceFolderText = SWTUtil.createPathBrowserText(container, "&Source folder:", new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewTestNGClassWizardPage.this.dialogChanged();
            }
        });
        Label label = new Label(container, 0);
        label.setText("&Package name:");
        this.m_packageNameText = new Text(container, 2052);
        this.m_packageNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewTestNGClassWizardPage.this.dialogChanged();
            }
        });
        GridData gd = new GridData(768);
        this.m_packageNameText.setLayoutData((Object)gd);
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewTestNGClassWizardPage.this.handleBrowsePackages(container.getShell());
            }
        });
        label = new Label(container, 0);
        label.setText("&Class name:");
        this.m_classNameText = new Text(container, 2052);
        gd = new GridData(768);
        this.m_classNameText.setLayoutData((Object)gd);
        this.m_classNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewTestNGClassWizardPage.this.dialogChanged();
            }
        });
    }

    private void createBottom(Composite parent) {
        Group g = new Group(parent, 64);
        g.setText("Annotations");
        GridData gd = new GridData(768);
        g.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        g.setLayout((Layout)layout);
        layout.numColumns = 3;
        String[] stringArray = ANNOTATIONS;
        int n = ANNOTATIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            if ("".equals(label)) {
                new Label((Composite)g, 0);
            } else {
                Button b = new Button((Composite)g, "".equals(label) ? 0 : 32);
                this.m_annotations.put(label, b);
                b.setText("@" + label);
            }
            ++n2;
        }
        Composite container = SWTUtil.createGridContainer(parent, 2);
        Label label = new Label(container, 0);
        label.setText(ResourceUtil.getString("TestNG.newClass.suitePath"));
        this.m_xmlFilePath = new Text(container, 2052);
        GridData gd2 = new GridData(768);
        gd2.grabExcessHorizontalSpace = true;
        this.m_xmlFilePath.setLayoutData((Object)gd2);
    }

    private void initialize() {
        this.m_elements = Utils.getSelectedJavaElements();
        if (this.m_elements.size() > 0) {
            Utils.JavaElement sel = this.m_elements.get(0);
            if (sel.sourceFolder != null) {
                this.m_sourceFolderText.setText(sel.sourceFolder);
            }
            if (sel.getPackageName() != null) {
                this.m_packageNameText.setText(sel.getPackageName());
            }
            String className = StringUtils.isEmptyString(sel.getClassName()) ? "NewTest" : String.valueOf(sel.getClassName()) + "Test";
            this.m_classNameText.setText(className);
        }
    }

    public List<Utils.JavaElement> getJavaElements() {
        return this.m_elements;
    }

    private void handleBrowsePackages(Shell dialogParrentShell) {
        try {
            Object[] selectedPackages;
            IResource sourceContainer = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getSourceFolder()));
            IJavaProject javaProject = JDTUtil.getJavaProject(sourceContainer.getProject().getName());
            SelectionDialog dialog = JavaUI.createPackageDialog((Shell)dialogParrentShell, (IJavaProject)javaProject, (int)0);
            dialog.setTitle("Package selection");
            dialog.setMessage("&Choose a package:");
            if (dialog.open() == 0 && (selectedPackages = dialog.getResult()).length == 1) {
                this.m_packageNameText.setText(((IPackageFragment)selectedPackages[0]).getElementName());
            }
        }
        catch (JavaModelException javaModelException) {
            this.updateStatus("Failed to list packages.");
        }
    }

    private void dialogChanged() {
        String ext;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getSourceFolder()));
        String className = this.getClassName();
        if (container.getProject() == null || container.getProject().getName() == null || container.getProject().getName().length() == 0) {
            this.updateStatus("The source folder of an existing project must be specified.");
            return;
        }
        if (this.getPackageName().length() == 0) {
            this.updateStatus("The package must be specified");
            return;
        }
        if (container != null && !container.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (className.length() == 0) {
            this.updateStatus("Class name must be specified");
            return;
        }
        if (className.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("Class name must be valid");
            return;
        }
        int dotLoc = className.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = className.substring(dotLoc + 1)).equalsIgnoreCase("java")) {
            this.updateStatus("File extension must be \"java\"");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getSourceFolder() {
        return this.m_sourceFolderText.getText();
    }

    public String getXmlFile() {
        return this.m_xmlFilePath.getText();
    }

    public String getPackageName() {
        return this.m_packageNameText.getText();
    }

    public String getClassName() {
        return this.m_classNameText.getText();
    }

    public boolean containsAnnotation(String annotation) {
        Button b = this.m_annotations.get(annotation);
        return b.getSelection();
    }

    public String getPackage() {
        return this.m_packageNameText.getText();
    }
}

