/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.testng.eclipse.util.CustomSuite;
import org.testng.reporters.XMLStringBuffer;

class ClassMethodsSuite
extends CustomSuite {
    protected List<String> m_classNames;
    protected Map<String, List<String>> m_classMethods;
    protected boolean m_useMethods;

    public ClassMethodsSuite(String projectName, List<String> classNames, Map<String, List<String>> classMethods, Map<String, String> parameters, int logLevel) {
        super(projectName, "Default suite", parameters, logLevel);
        this.m_classNames = classNames;
        Map<String, List<String>> map = this.m_classMethods = classMethods != null ? this.sanitize(classMethods) : classMethods;
        if (this.m_useMethods) {
            this.m_classNames = new ArrayList<String>(this.m_classMethods.keySet());
        }
    }

    private Map<String, List<String>> sanitize(Map<String, List<String>> classMethods) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, List<String>> entry : classMethods.entrySet()) {
            String clsName = entry.getKey();
            List<String> methods = entry.getValue();
            if (methods == null || methods.isEmpty()) {
                result.put(clsName, null);
                continue;
            }
            ArrayList methodNames = Lists.newArrayList();
            for (String meth : methods) {
                if (meth == null || "".equals(meth)) continue;
                methodNames.add(meth);
            }
            if (methodNames.isEmpty()) {
                result.put(clsName, null);
                continue;
            }
            result.put(clsName, methodNames);
            this.m_useMethods = true;
        }
        return result;
    }

    @Override
    protected String getTestName() {
        return "Default test";
    }

    @Override
    protected void classesElement(XMLStringBuffer suiteBuffer) {
        if (this.m_useMethods) {
            this.generateClassesWithMethodsElement(suiteBuffer);
        } else {
            this.generateDefaultClassesElement(suiteBuffer, this.m_classNames);
        }
    }

    protected void generateClassesWithMethodsElement(XMLStringBuffer suiteBuffer) {
        suiteBuffer.push("classes");
        for (Map.Entry<String, List<String>> entry : this.m_classMethods.entrySet()) {
            String className = entry.getKey();
            Properties classAttrs = new Properties();
            classAttrs.setProperty("name", className);
            List<String> methodNames = entry.getValue();
            if (methodNames == null) {
                suiteBuffer.addEmptyElement("class", classAttrs);
                continue;
            }
            suiteBuffer.push("class", classAttrs);
            suiteBuffer.push("methods");
            for (String name : methodNames) {
                Properties methodAttrs = new Properties();
                methodAttrs.setProperty("name", name);
                suiteBuffer.addEmptyElement("include", methodAttrs);
            }
            suiteBuffer.pop("methods");
            suiteBuffer.pop("class");
        }
        suiteBuffer.pop("classes");
    }
}

