/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.refactoring;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ui.IWorkbenchPage;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.refactoring.SourceFolderChange;
import org.testng.eclipse.util.JDTUtil;
import org.testng.eclipse.util.Utils;

public class ConvertFromJUnitCompositeChange
extends CompositeChange {
    private IProgressMonitor m_pm;
    private IWorkbenchPage m_page;
    private Map<String, Set<IResource>> m_classes = Maps.newHashMap();

    public ConvertFromJUnitCompositeChange(IProgressMonitor pm, IWorkbenchPage page) {
        super("Composite change");
        this.m_pm = pm;
        this.m_page = page;
        this.markAsSynthetic();
        this.computeChanges();
    }

    private void computeChanges() {
        TestNGPlugin.asyncExec(new Runnable(){

            @Override
            public void run() {
                IJavaProject javaProject = JDTUtil.getJavaProjectContext();
                if (javaProject == null) {
                    return;
                }
                List<IType> types = Utils.findSelectedTypes(ConvertFromJUnitCompositeChange.this.m_page, Utils.CONVERSION_FILTER);
                ConvertFromJUnitCompositeChange.this.m_pm.beginTask("Finding test classes", types.size());
                for (IType iType : types) {
                    for (IClasspathEntry entry : Utils.getSourceFolders(javaProject)) {
                        String sourceFolder = entry.getPath().toOSString();
                        IResource resource = iType.getResource();
                        if (!resource.getFullPath().toOSString().contains(sourceFolder)) continue;
                        Set l = (Set)ConvertFromJUnitCompositeChange.this.m_classes.get(sourceFolder);
                        if (l == null) {
                            l = Sets.newHashSet();
                            ConvertFromJUnitCompositeChange.this.m_classes.put(sourceFolder, l);
                        }
                        l.add(resource);
                        ConvertFromJUnitCompositeChange.this.m_pm.worked(1);
                    }
                }
                for (Map.Entry entry : ConvertFromJUnitCompositeChange.this.m_classes.entrySet()) {
                    ConvertFromJUnitCompositeChange.this.add((Change)new SourceFolderChange((String)entry.getKey(), (Collection)entry.getValue()));
                }
                ConvertFromJUnitCompositeChange.this.m_pm.done();
            }
        });
    }

    public String getName() {
        return "Convert to TestNG";
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public Object getModifiedElement() {
        return null;
    }
}

