/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.matcher.internal;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.springframework.ide.eclipse.aop.core.internal.model.AopReference;
import org.springframework.ide.eclipse.aop.core.internal.model.builder.AspectDefinitionMatcher;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.model.IAspectDefinition;
import org.springframework.ide.eclipse.aop.ui.matcher.internal.PointcutMatcherMessages;
import org.springframework.ide.eclipse.aop.ui.matcher.internal.PointcutMatcherResult;
import org.springframework.ide.eclipse.aop.ui.matcher.internal.PointcutMatcherScope;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.java.ClassUtils;
import org.springframework.ide.eclipse.core.java.IProjectClassLoaderSupport;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.util.Assert;

public class PointcutMatchQuery
implements ISearchQuery {
    private PointcutMatcherScope scope;
    private String expression;
    private ISearchResult result;
    private boolean isProxyTragetClass;

    public PointcutMatchQuery(PointcutMatcherScope scope, String pattern, boolean isProxyTragetClass) {
        Assert.notNull((Object)scope);
        this.scope = scope;
        this.expression = pattern;
        this.isProxyTragetClass = isProxyTragetClass;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    private IProjectClassLoaderSupport getClassLoaderSupport(IProject project) {
        return JdtUtils.getProjectClassLoaderSupport((IProject)project, null);
    }

    public String getExpression() {
        return this.expression;
    }

    public String getLabel() {
        return PointcutMatcherMessages.MatcherQuery_label;
    }

    private Set<IAopReference> getMatches(Set<IBean> beans, IAspectDefinition definition, AspectDefinitionMatcher matcher) {
        HashSet<IAopReference> references = new HashSet<IAopReference>();
        for (IBean bean : beans) {
            IProject project = bean.getElementResource().getProject();
            if (bean.isInfrastructure()) continue;
            String className = BeansModelUtils.getBeanClass((IBean)bean, null);
            try {
                Class targetClass = ClassUtils.loadClass((String)className);
                Set matchingMethods = matcher.matches(targetClass, bean, definition, project);
                for (IMethod method : matchingMethods) {
                    AopReference ref = new AopReference(definition.getType(), null, -1, (IMember)method, JdtUtils.getLineNumber((IJavaElement)method), definition, bean.getElementResource(), bean);
                    references.add((IAopReference)ref);
                }
            }
            catch (Throwable throwable) {}
        }
        return references;
    }

    public PointcutMatcherScope getScope() {
        return this.scope;
    }

    public final ISearchResult getSearchResult() {
        if (this.result == null) {
            this.result = new PointcutMatcherResult(this);
        }
        return this.result;
    }

    public final IStatus run(IProgressMonitor monitor) {
        final PointcutMatcherResult result = (PointcutMatcherResult)this.getSearchResult();
        result.removeAll();
        final PointcutDefinition definition = new PointcutDefinition(this.isProxyTragetClass, this.expression);
        IModelElement[] iModelElementArray = this.scope.getModelElements();
        int n = iModelElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement element = iModelElementArray[n2];
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IModelElementVisitor visitor = new IModelElementVisitor(){

                public boolean visit(IModelElement element, IProgressMonitor monitor) {
                    if (element instanceof IBeansConfig) {
                        IBeansConfig config = (IBeansConfig)element;
                        monitor.beginTask("Matching pointcut in file [" + config.getElementResource().getProjectRelativePath().toString() + "]", 100);
                        IProject project = config.getElementResource().getProject();
                        try {
                            final Set beans = BeansModelUtils.getBeans((IModelElement)config);
                            PointcutMatchQuery.this.getClassLoaderSupport(project).executeCallback(new IProjectClassLoaderSupport.IProjectClassLoaderAwareCallback(){

                                public void doWithActiveProjectClassLoader() throws Throwable {
                                    for (IAopReference reference : PointcutMatchQuery.this.getMatches(beans, definition, new AspectDefinitionMatcher())) {
                                        Match match = new Match((Object)reference, 1, -1, -1);
                                        result.addMatch(match);
                                    }
                                }
                            });
                        }
                        catch (Throwable throwable) {}
                        return false;
                    }
                    return true;
                }
            };
            element.accept(visitor, monitor);
            ++n2;
        }
        Object[] args = new Object[]{new Integer(result.getMatchCount())};
        String message = MessageUtils.format((String)PointcutMatcherMessages.MatcherQuery_status, (Object[])args);
        return new Status(0, "org.springframework.ide.eclipse.aop.ui.matcher", 0, message, null);
    }

    private static class PointcutDefinition
    implements IAspectDefinition {
        private final boolean isProxyTargetClass;
        private final String expression;

        public PointcutDefinition(boolean isProxyTargetClass, String expression) {
            this.isProxyTargetClass = isProxyTargetClass;
            this.expression = expression;
        }

        public Method getAdviceMethod() {
            return null;
        }

        public String getAdviceMethodName() {
            return null;
        }

        public String[] getAdviceMethodParameterTypes() {
            return null;
        }

        public String[] getArgNames() {
            return null;
        }

        public String getAspectClassName() {
            return null;
        }

        public int getAspectEndLineNumber() {
            return 0;
        }

        public String getAspectName() {
            return null;
        }

        public int getAspectStartLineNumber() {
            return 0;
        }

        public String getPointcutExpression() {
            return this.expression;
        }

        public IResource getResource() {
            return null;
        }

        public String getReturning() {
            return null;
        }

        public String getThrowing() {
            return null;
        }

        public IAopReference.ADVICE_TYPE getType() {
            return null;
        }

        public boolean isProxyTargetClass() {
            return this.isProxyTargetClass;
        }

        public void setResource(IResource file) {
        }
    }
}

